/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.finance.tax;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxAmount;
import au.com.ordermate.util.finance.tax.TaxCalculation;
import au.com.ordermate.util.finance.tax.TaxCodeI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

class SequentialTaxCalculation
implements TaxCalculation {
    private final TaxCodeI[] taxCodes;

    static boolean isApplicable(List<? extends TaxCodeI> codes) {
        if (codes == null || codes.size() == 0) {
            return false;
        }
        HashSet<Integer> sequences = new HashSet<Integer>();
        for (TaxCodeI taxCodeI : codes) {
            sequences.add(taxCodeI.getSequence());
        }
        return codes.size() == sequences.size();
    }

    SequentialTaxCalculation(List<? extends TaxCodeI> codes) {
        ArrayList<? extends TaxCodeI> sortedList = new ArrayList<TaxCodeI>(codes);
        Collections.sort(sortedList, new Comparator<TaxCodeI>(){

            @Override
            public int compare(TaxCodeI o1, TaxCodeI o2) {
                return Double.compare(o1.getSequence(), o2.getSequence());
            }
        });
        this.taxCodes = sortedList.toArray(new TaxCodeI[sortedList.size()]);
    }

    @Override
    public Price getUntaxedPrice(Price totalPrice) {
        double nextBasePrice = totalPrice.doubleValue();
        for (int i = this.taxCodes.length - 1; i >= 0; --i) {
            nextBasePrice /= 1.0 + this.taxCodes[i].getRate();
        }
        return new Price(nextBasePrice, 0.0);
    }

    @Override
    public Price getPriceIncTax(Price priceExTax) {
        double nextBasePrice = priceExTax.doubleValue();
        for (int i = this.taxCodes.length - 1; i >= 0; --i) {
            nextBasePrice *= 1.0 + this.taxCodes[i].getRate();
        }
        return new Price(nextBasePrice, 0.0);
    }

    @Override
    public Price getTotalTax(Price totalPrice) {
        return totalPrice.subtract(this.getUntaxedPrice(totalPrice));
    }

    @Override
    public List<TaxAmount> getTaxAmounts(Price totalPrice) {
        TaxAmount[] amounts = new TaxAmount[this.taxCodes.length];
        double runningBase = totalPrice.doubleValue();
        for (int i = this.taxCodes.length - 1; i >= 0; --i) {
            double taxAmount = this.taxCodes[i].getRate() * (runningBase /= 1.0 + this.taxCodes[i].getRate());
            amounts[i] = new TaxAmount(this.taxCodes[i], new Price(taxAmount, 0.0));
        }
        return Arrays.asList(amounts);
    }

    public String toString() {
        return "SequentialTax:" + Arrays.toString(this.taxCodes);
    }

    @Override
    public Price getTaxFromExTaxPrice(Price extaxPrice) {
        return this.getPriceIncTax(extaxPrice).subtract(extaxPrice);
    }
}

