/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.finance.tax;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxAmount;
import au.com.ordermate.util.finance.tax.TaxCalculation;
import au.com.ordermate.util.finance.tax.TaxCodeI;
import java.util.Collections;
import java.util.List;

public class SimpleTaxCalculation
implements TaxCalculation {
    private final TaxCodeI taxCode;

    static boolean isApplicable(List<? extends TaxCodeI> codes) {
        return codes != null && codes.size() == 1;
    }

    public SimpleTaxCalculation(List<? extends TaxCodeI> yourTaxCodes) {
        this.taxCode = yourTaxCodes.get(0);
    }

    @Override
    public Price getUntaxedPrice(Price totalPrice) {
        double totalRate = 1.0 + this.taxCode.getRate();
        return new Price(totalPrice.doubleValue() / totalRate, 0.0);
    }

    @Override
    public Price getTotalTax(Price totalPrice) {
        return new Price(totalPrice.doubleValue() - this.getUntaxedPrice(totalPrice).doubleValue(), 0.0);
    }

    @Override
    public List<TaxAmount> getTaxAmounts(Price totalPrice) {
        return Collections.singletonList(new TaxAmount(this.taxCode, this.getTotalTax(totalPrice)));
    }

    @Override
    public Price getPriceIncTax(Price priceExTax) {
        double totalRate = 1.0 + this.taxCode.getRate();
        return new Price(priceExTax.doubleValue() * totalRate, 0.0);
    }

    @Override
    public Price getTaxFromExTaxPrice(Price extaxPrice) {
        return new Price(extaxPrice.doubleValue() * this.taxCode.getRate(), 0.0);
    }

    public String toString() {
        return "SimpleTax:" + this.taxCode.toString();
    }
}

