/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.finance.tax;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.ComplexTaxCalculation;
import au.com.ordermate.util.finance.tax.NoTaxCalculation;
import au.com.ordermate.util.finance.tax.SequentialTaxCalculation;
import au.com.ordermate.util.finance.tax.SimpleTaxCalculation;
import au.com.ordermate.util.finance.tax.TaxAmount;
import au.com.ordermate.util.finance.tax.TaxCalculation;
import au.com.ordermate.util.finance.tax.TaxCodeI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;

public class TaxMan {
    private static TaxMan instance;
    private final Map<Long, TaxCalculation> calcMap = new HashMap<Long, TaxCalculation>();

    private TaxMan() {
    }

    public static TaxMan getInstance() {
        if (instance == null) {
            instance = new TaxMan();
        }
        return instance;
    }

    public Price getTotalTax(Price totalPrice, List<? extends TaxCodeI> appliedCodes) {
        if (totalPrice.getRoundAmount() == 0.0) {
            return this.getCalculation(appliedCodes).getTotalTax(totalPrice);
        }
        return this.getCalculation(appliedCodes).getTotalTax(this.getUnrounded(totalPrice));
    }

    public Price getUntaxedPrice(Price totalPrice, List<? extends TaxCodeI> appliedCodes) {
        return this.getCalculation(appliedCodes).getUntaxedPrice(this.getUnrounded(totalPrice));
    }

    public List<TaxAmount> getTaxAmounts(Price totalPrice, List<? extends TaxCodeI> appliedCodes) {
        return this.getCalculation(appliedCodes).getTaxAmounts(this.getUnrounded(totalPrice));
    }

    public Price getUntaxedPrice(Price totalPrice, List<? extends PropertiedObject> taxHolders, PropertiedObject.Property<? extends TaxCodeI> property) {
        if (taxHolders == null || taxHolders.size() == 0) {
            return totalPrice;
        }
        if (taxHolders.size() == 1) {
            return this.getUntaxedPrice(totalPrice, Collections.singletonList(PropertiedObject.PropsHelper.getPropertyValue(taxHolders.get(0), property)));
        }
        ArrayList<TaxCodeI> codes = new ArrayList<TaxCodeI>(taxHolders.size());
        for (int i = 0; i < taxHolders.size(); ++i) {
            codes.add(PropertiedObject.PropsHelper.getPropertyValue(taxHolders.get(i), property));
        }
        return this.getUntaxedPrice(totalPrice, codes);
    }

    private Price getUnrounded(Price value) {
        if (value.getRoundAmount() != 0.0) {
            return new Price(value.doubleValue(), 0.0);
        }
        return value;
    }

    private TaxCalculation getCalculation(List<? extends TaxCodeI> appliedCodes) {
        Long actualKey;
        long key = 0L;
        if (appliedCodes != null) {
            if (appliedCodes.size() == 1) {
                key = appliedCodes.get(0).hashCode();
            } else if (appliedCodes.size() > 1) {
                for (TaxCodeI taxCodeI : appliedCodes) {
                    key += (long)taxCodeI.hashCode();
                }
            }
        }
        if (this.calcMap.get(actualKey = Long.valueOf(key)) == null) {
            TaxCalculation taxCalculation = this.createCalculation(appliedCodes);
            this.calcMap.put(actualKey, taxCalculation);
        }
        return this.calcMap.get(actualKey);
    }

    private TaxCalculation createCalculation(List<? extends TaxCodeI> appliedCodes) {
        if (NoTaxCalculation.isApplicable(appliedCodes)) {
            OrderMate.LOG.info("Creating a NoTaxCode calculation for " + appliedCodes);
            return new NoTaxCalculation();
        }
        if (SimpleTaxCalculation.isApplicable(appliedCodes)) {
            OrderMate.LOG.info("Creating Tax Code Calculation for :" + appliedCodes);
            return new SimpleTaxCalculation(appliedCodes);
        }
        if (SequentialTaxCalculation.isApplicable(appliedCodes)) {
            OrderMate.LOG.info("Creating Sequential Tax Code Calculation for :" + appliedCodes);
            return new SequentialTaxCalculation(appliedCodes);
        }
        if (ComplexTaxCalculation.isApplicable(appliedCodes)) {
            OrderMate.LOG.info("Creating Complex Tax Code Calculation for " + appliedCodes);
            return new ComplexTaxCalculation(appliedCodes);
        }
        throw new IllegalArgumentException("Cannot create a tax code for the set of codes :" + appliedCodes);
    }

    public Price getPriceIncTax(Price priceExTax, List<? extends TaxCodeI> appliedCodes) {
        return priceExTax.getRoundAmount() == 0.0 ? this.getCalculation(appliedCodes).getPriceIncTax(priceExTax) : this.getCalculation(appliedCodes).getPriceIncTax(this.getUnrounded(priceExTax));
    }

    public Price getTaxFromExTaxPrice(Price priceExTax, List<? extends TaxCodeI> appliedCodes) {
        return priceExTax.getRoundAmount() == 0.0 ? this.getCalculation(appliedCodes).getTaxFromExTaxPrice(priceExTax) : this.getCalculation(appliedCodes).getTaxFromExTaxPrice(this.getUnrounded(priceExTax));
    }
}

