/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.id;

import au.com.ordermate.util.id.ScrambledIdGenerator;

public class MuddledIdGenerator
extends ScrambledIdGenerator {
    private final int rem;
    private int[] reverseChars;

    public MuddledIdGenerator(int seed, int size, String prefix) {
        super(seed, size, prefix);
        this.rem = this.chars.length;
    }

    @Override
    protected void populateCharMap(boolean numbersOnly) {
        super.populateCharMap(numbersOnly);
        this.reverseChars = new int[91];
        for (int i = 0; i < this.chars.length; ++i) {
            this.reverseChars[this.chars[i]] = i;
        }
    }

    @Override
    public String getId(String seed) {
        int index = 0;
        String superId = super.getId(seed);
        index = this.reverseChars[superId.charAt(superId.length() - 1)];
        StringBuilder SB = new StringBuilder(this.prefix);
        for (int i = this.prefix.length(); i < superId.length() - 1; ++i) {
            int nextChar = this.reverseChars[superId.charAt(i)];
            nextChar = this.chars[(nextChar + index) % this.rem];
            SB.append((char)nextChar);
        }
        SB.append(superId.charAt(superId.length() - 1));
        return SB.toString();
    }

    @Override
    public String unscramble(String value) {
        int index = this.reverseChars[value.charAt(value.length() - 1)];
        StringBuilder SB = new StringBuilder(this.prefix);
        for (int i = this.prefix.length(); i < value.length() - 1; ++i) {
            char nextChar = value.charAt(i);
            int undo = this.reverseChars[nextChar] - index;
            if (undo < 0) {
                undo += this.chars.length;
            }
            nextChar = this.chars[undo];
            SB.append(nextChar);
        }
        SB.append(value.charAt(value.length() - 1));
        String unmuddled = SB.toString();
        return super.unscramble(unmuddled);
    }
}

