/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.id;

import au.com.ordermate.util.id.IdGenerator;
import au.com.ordermate.util.id.SimpleIdGenerator;

public class ScrambledIdGenerator
implements IdGenerator {
    private SimpleIdGenerator generator;
    protected char[] chars;
    protected final String prefix;
    protected final int scrambleSeed;
    protected final int size;

    public ScrambledIdGenerator(int seed, int size, String prefix) {
        boolean numbersOnly = false;
        this.prefix = prefix;
        this.scrambleSeed = seed;
        this.size = size;
        this.generator = new SimpleIdGenerator(size + prefix.length(), prefix, true);
        this.populateCharMap(numbersOnly);
    }

    protected void populateCharMap(boolean numbersOnly) {
        int i;
        this.chars = numbersOnly ? new char[10] : new char[36];
        for (i = 0; i < 10; ++i) {
            this.chars[i] = (char)(48 + i);
        }
        if (!numbersOnly) {
            for (i = 0; i < 26; ++i) {
                this.chars[i + 10] = (char)(65 + i);
            }
        }
        int prefixSum = 0;
        for (int i2 = 0; i2 < this.prefix.length(); ++i2) {
            prefixSum += this.prefix.charAt(i2);
        }
        int starting = this.size + prefixSum + 17 + this.scrambleSeed;
        starting %= this.chars.length;
        for (int i3 = 0; i3 < this.chars.length; ++i3) {
            char toSwap = this.chars[i3];
            this.chars[i3] = this.chars[starting];
            this.chars[starting] = toSwap;
            starting = (starting + 3) % this.chars.length;
        }
    }

    @Override
    public String nextSeed(String previousSeed) {
        return this.generator.nextSeed(previousSeed);
    }

    @Override
    public String getId(String seed) {
        StringBuilder SB = new StringBuilder(this.prefix);
        int count = 0;
        for (int i = this.prefix.length(); i < seed.length(); ++i) {
            char nextChar = seed.charAt(i);
            for (int j = 0; j < this.chars.length; ++j) {
                if (this.chars[j] != nextChar) continue;
                SB.append(this.chars[(j + count) % this.chars.length]);
                break;
            }
            ++count;
        }
        return SB.toString();
    }

    public String unscramble(String value) {
        StringBuilder SB = new StringBuilder(this.prefix);
        int count = 0;
        for (int i = this.prefix.length(); i < value.length(); ++i) {
            char nextChar = value.charAt(i);
            for (int j = 0; j < this.chars.length; ++j) {
                if (this.chars[j] != nextChar) continue;
                SB.append(this.chars[(this.chars.length + j - count) % this.chars.length]);
                break;
            }
            ++count;
        }
        return SB.toString();
    }
}

