/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.id;

import au.com.ordermate.util.id.IdGenerator;

public class SimpleIdGenerator
implements IdGenerator {
    private static final char firstDigit = '0';
    private static final char lastDigit = '9';
    private static final char firstLetter = 'a';
    private static final char lastLetter = 'z';
    private static final char firstLetterCaps = 'A';
    private static final char lastLetterCaps = 'Z';
    private final int size;
    private final String prefix;
    private final boolean caps;

    public SimpleIdGenerator() {
        this(24, "05");
    }

    public SimpleIdGenerator(int size, String prefix) {
        this(size, prefix, false);
    }

    public SimpleIdGenerator(int size, String prefix, boolean caps) {
        this.size = size;
        this.prefix = prefix;
        this.caps = caps;
    }

    @Override
    public String getId(String seed) {
        int aLetter = this.caps ? 65 : 97;
        char zLetter = this.caps ? (char)'Z' : 'z';
        char[] newChars = new char[this.size];
        if (seed == null) {
            int i;
            for (i = 0; i < newChars.length; ++i) {
                newChars[i] = 48;
            }
            newChars[newChars.length - 1] = (char)(newChars[newChars.length - 1] + '\u0001');
            for (i = 0; i < this.prefix.length(); ++i) {
                newChars[i] = this.prefix.charAt(i);
            }
        } else {
            int i;
            if (seed.length() != newChars.length) {
                throw new IllegalStateException("SimpleID Generator can only work with fixed width strings: " + seed + " is not the same size as " + this.size);
            }
            char[] chars = seed.toCharArray();
            for (i = 0; i < chars.length; ++i) {
                newChars[i] = chars[i];
            }
            for (i = newChars.length - 1; i >= this.prefix.length(); --i) {
                if (newChars[i] == '9') {
                    newChars[i] = aLetter;
                    break;
                }
                if (newChars[i] != zLetter) {
                    newChars[i] = (char)(newChars[i] + '\u0001');
                    break;
                }
                newChars[i] = 48;
            }
        }
        return new String(newChars);
    }

    @Override
    public String nextSeed(String previousSeed) {
        return this.getId(previousSeed);
    }
}

