/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Writer;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.Code39Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import ordermate.OrderMate;

public class BarcodeImageHelper {
    public BufferedImage makeQrCode(String value, int width, int height) {
        return this.makeImage((Writer)new QRCodeWriter(), BarcodeFormat.QR_CODE, value, width, height);
    }

    public BufferedImage makeCode39Barcode(String value, int width, int height) {
        return this.makeImage((Writer)new Code39Writer(), BarcodeFormat.CODE_39, value, width, height);
    }

    public BufferedImage makeCode128Barcode(String value, int width, int height) {
        return this.makeImage((Writer)new Code128Writer(), BarcodeFormat.CODE_128, value, width, height);
    }

    public BufferedImage makeEan13Barcode(String value, int width, int height) {
        return this.makeImage((Writer)new EAN13Writer(), BarcodeFormat.EAN_13, value, width, height);
    }

    public BufferedImage makeImage(Writer writer, BarcodeFormat format, String value, int width, int height) {
        try {
            BitMatrix bitMatrix = writer.encode(value, format, width, height);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create with " + writer, (Throwable)ex);
            return null;
        }
    }
}

