/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class ColourWheel {
    private List<Color> colours = new ArrayList<Color>();

    public ColourWheel(int wheelSize, Palette palette) {
        for (int i = 0; i < wheelSize; ++i) {
            this.colours.add(palette.makeColour(i));
        }
    }

    public Color getColour(int value) {
        return this.colours.get(value % this.colours.size());
    }

    public ImageIcon makeSwatch() {
        int size = 6;
        BufferedImage BI = new BufferedImage(36, 36, 1);
        Graphics g = BI.getGraphics();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                g.setColor(this.getColour(i * size + j));
                g.fillRect(i * size, j * size, size, size);
            }
        }
        BI.flush();
        return new ImageIcon(BI);
    }

    public static enum Palette {
        Ocean{

            @Override
            public Color makeColour(int index) {
                int red = 120 - Math.abs((50 + 31 * index) % 80);
                int green = 220 - Math.abs((30 + 19 * index) % 80);
                int blue = 220 - Math.abs((20 + 23 * index) % 80);
                return new Color(red, green, blue);
            }
        }
        ,
        Stone{

            @Override
            public Color makeColour(int index) {
                int red = 220 - Math.abs((50 + 19 * index) % 80);
                int green = 180 - Math.abs((30 + 31 * index) % 120);
                int blue = 120 - Math.abs((20 + 23 * index) % 80);
                return new Color(red, green, blue);
            }
        }
        ,
        Garden{

            @Override
            public Color makeColour(int index) {
                int red = 220 - Math.abs((50 + 31 * index) % 120);
                int green = 180 - Math.abs((30 + 19 * index) % 120);
                int blue = 120 - Math.abs((20 + 23 * index) % 80);
                return new Color(red, green, blue);
            }
        }
        ,
        Floral{

            @Override
            public Color makeColour(int index) {
                int red = 220 - Math.abs((50 + 31 * index) % 80);
                int green = 120 - Math.abs((30 + 19 * index) % 80);
                int blue = 200 - Math.abs((20 + 23 * index) % 180);
                return new Color(red, green, blue);
            }
        }
        ,
        Forest{

            @Override
            public Color makeColour(int index) {
                int red = 150 - Math.abs((50 + 31 * index) % 150);
                int green = 240 - Math.abs((30 + 19 * index) % 50);
                int blue = 150 - Math.abs((20 + 23 * index) % 150);
                return new Color(red, green, blue);
            }
        }
        ,
        Sand{

            @Override
            public Color makeColour(int index) {
                int red = 250 - Math.abs((50 + 31 * index) % 80);
                int green = 220 - Math.abs((90 + 19 * index) % 50);
                int blue = 83 - Math.abs((20 + 23 * index) % 40);
                return new Color(red, green, blue);
            }
        }
        ,
        Pastel{

            @Override
            public Color makeColour(int index) {
                int red = 220 - Math.abs((50 + 31 * index) % 80);
                int green = 220 - Math.abs((30 + 19 * index) % 80);
                int blue = 220 - Math.abs((20 + 23 * index) % 80);
                return new Color(red, green, blue);
            }
        }
        ,
        Greys{

            @Override
            public Color makeColour(int index) {
                int value = 240 - Math.abs(80 + 319 * index) % 200;
                return new Color(value, value, value);
            }
        }
        ,
        Rainbow{

            @Override
            public Color makeColour(int index) {
                int red = 240 - Math.abs((50 + 43 * index) % 200);
                int green = 240 - Math.abs((101 + 91 * index) % 200);
                int blue = 240 - Math.abs((1 + 319 * index) % 200);
                return new Color(red, green, blue);
            }
        }
        ,
        Contrast{

            @Override
            public Color makeColour(int index) {
                int red = Math.abs((50 + 43 * index) % 255);
                int green = 255 - Math.abs(red + 70 * index) % 255;
                int blue = 255 - (red + green) % 255;
                return new Color(red, green, blue);
            }
        };


        public abstract Color makeColour(int var1);
    }
}

