/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import ordermate.OrderMate;

public class FragmentedGif {
    private final List<BufferedImage> frames = new ArrayList<BufferedImage>();
    private final List<IIOMetadata> frameMetadata = new ArrayList<IIOMetadata>();

    public void addFrame(BufferedImage frame, IIOMetadata metadata) {
        this.frames.add(frame);
        this.frameMetadata.add(metadata);
    }

    public List<BufferedImage> getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public List<IIOMetadata> getFrameMetadata() {
        return Collections.unmodifiableList(this.frameMetadata);
    }

    public ImageIcon getImageIcon() {
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("gif").next();
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(ba);
            imageWriter.setOutput(outputStream);
            imageWriter.prepareWriteSequence(null);
            for (int i = 0; i < this.frames.size(); ++i) {
                IIOImage frameImage = new IIOImage(this.frames.get(i), null, this.frameMetadata.get(i));
                imageWriter.writeToSequence(frameImage, null);
            }
            imageWriter.endWriteSequence();
            outputStream.flush();
            return new ImageIcon(ba.toByteArray());
        }
        catch (IOException e) {
            OrderMate.LOG.error("Error encountered while converting FragmentedGif to ImageIcon", (Throwable)e);
            return new ImageIcon();
        }
    }
}

