/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import au.com.ordermate.util.image.FragmentedGif;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import ordermate.OrderMate;

public class GifLoader {
    public FragmentedGif loadGif(String filename) {
        FragmentedGif gif = new FragmentedGif();
        ImageReader imageReader = ImageIO.getImageReadersByFormatName("gif").next();
        try {
            ImageInputStream inputStream = ImageIO.createImageInputStream(Objects.requireNonNull(GifLoader.class.getResourceAsStream(filename)));
            imageReader.setInput(inputStream, false);
            int imageCount = imageReader.getNumImages(true);
            for (int i = 0; i < imageCount; ++i) {
                BufferedImage frame = imageReader.read(i);
                IIOMetadata metadata = imageReader.getImageMetadata(i);
                gif.addFrame(frame, metadata);
            }
            return gif;
        }
        catch (IOException | NullPointerException ioException) {
            OrderMate.LOG.error(String.format("Error encountered reading %s", filename), (Throwable)ioException);
            return null;
        }
    }
}

