/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconLoader {
    public static final String BROKEN_LINK = "/ordermate/images/brokenLink.png";
    private static final Map<String, ImageIcon> cachedIcons = new HashMap<String, ImageIcon>();
    private static double scale = 1.0;
    private static Color tint = null;
    private static float tintFactor = 1.0f;

    public static void resetScale(double newFactor) {
        cachedIcons.clear();
        scale = newFactor / 100.0;
    }

    public static void resetTint(Color newTint) {
        cachedIcons.clear();
        tint = newTint;
    }

    public static ImageIcon get(String fileName, String defaultIcon) {
        ImageIcon toReturn;
        try {
            toReturn = IconLoader.get(fileName);
        }
        catch (IconNotFoundException e) {
            toReturn = IconLoader.get(defaultIcon);
        }
        return toReturn;
    }

    public static ImageIcon get(String filename) throws IconNotFoundException {
        return IconLoader.get(filename, scale, tint, tintFactor);
    }

    public static ImageIcon get(String filename, double givenScaleFactor, Color givenTint, float tintFactor) throws IconNotFoundException {
        String key = IconLoader.buildKey(filename, givenScaleFactor, givenTint);
        ImageIcon icon = cachedIcons.get(key);
        if (icon == null) {
            icon = IconLoader.createIcon(filename);
            if (givenScaleFactor != 1.0) {
                IconLoader.resizeIcon(icon, givenScaleFactor);
            }
            if (givenTint != null) {
                float clampedTint = MathsUtils.clamp(tintFactor, 1.0f, 0.0f);
                IconLoader.tintIcon(icon, givenTint, clampedTint);
            }
            cachedIcons.put(key, icon);
        }
        return icon;
    }

    private static String buildKey(String filename, double givenScaleFactor, Color givenTint) {
        String key = filename;
        if (givenScaleFactor != 1.0) {
            key = key + givenScaleFactor;
        }
        if (givenTint != null) {
            key = key + givenTint.toString();
        }
        return key;
    }

    private static void resizeIcon(ImageIcon icon, double scaleFactor) {
        ImageHelper helper = new ImageHelper();
        Image img = icon.getImage();
        if (img.getWidth(null) > 0 && img.getHeight(null) > 0) {
            icon.setImage(helper.rescaleImage(img, scaleFactor));
        }
    }

    private static void tintIcon(ImageIcon icon, Color newColor, float tintFactor) {
        ImageHelper helper = new ImageHelper();
        Image img = icon.getImage();
        if (img.getWidth(null) > 0 && img.getHeight(null) > 0) {
            icon.setImage(helper.tintImage(img, newColor, tintFactor));
        }
    }

    public static ImageIcon getCached(String fileName) {
        return cachedIcons.get(fileName);
    }

    public static void put(String key, ImageIcon icon) {
        cachedIcons.put(key, icon);
    }

    public static int getWidth(String filename) {
        return IconLoader.get(filename).getIconWidth();
    }

    public static int getHeight(String filename) {
        return IconLoader.get(filename).getIconHeight();
    }

    public static Image getImage(String filename) {
        ImageIcon icon = IconLoader.get(filename);
        if (icon == null || icon.getImageLoadStatus() != 8) {
            throw new IconNotFoundException("Could not find icon with filename :" + filename + " : " + icon + ", MediaTracker status : " + (icon != null ? icon.getImageLoadStatus() + "" : " icon is null"));
        }
        return icon.getImage();
    }

    private static final ImageIcon createIcon(String path) {
        ImageIcon icon;
        block7: {
            icon = null;
            try {
                icon = new ImageIcon(IconLoader.class.getResource(path));
            }
            catch (NullPointerException npe) {
                try {
                    icon = new ImageIcon(new URL(path));
                }
                catch (Exception mue) {
                    if (icon != null) break block7;
                    try {
                        String fileName = "file:" + path;
                        icon = new ImageIcon(new URL(fileName));
                        if (icon == null || icon.getImage() == null || icon.getIconHeight() < 0 || icon.getIconWidth() < 0) {
                            throw new IconNotFoundException(fileName + " is unable to be resolved into an icon.", null);
                        }
                    }
                    catch (Exception ex) {
                        throw new IconNotFoundException("IconLoader couldn't find the icon specified in:" + path, ex);
                    }
                }
            }
        }
        return icon;
    }

    public static Map<String, ImageIcon> getCache() {
        return cachedIcons;
    }

    public static double getScale() {
        return scale;
    }

    public static Color getTint() {
        return tint;
    }

    public static float getTintFactor() {
        return tintFactor;
    }

    public static ImageIcon getBrokenIcon() {
        try {
            return IconLoader.get(BROKEN_LINK);
        }
        catch (IconNotFoundException ex) {
            return null;
        }
    }

    public static class IconNotFoundException
    extends RuntimeException {
        public IconNotFoundException(String msg, Exception ex) {
            super(msg, ex);
        }

        public IconNotFoundException(String msg) {
            super(msg);
        }
    }
}

