/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import au.com.ordermate.util.image.ImageFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.OrderMate;
import org.jdesktop.swingx.image.ColorTintFilter;
import sun.awt.image.ToolkitImage;

public class ImageHelper {
    private Object interpolationRH = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private Object antiAliasingRH = RenderingHints.VALUE_ANTIALIAS_DEFAULT;

    public Image ghostify(Image image, float alphaBlend) {
        BufferedImage BI = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g2 = (Graphics2D)BI.getGraphics();
        AlphaComposite composite = AlphaComposite.getInstance(2, alphaBlend);
        g2.setComposite(composite);
        g2.drawImage(image, 0, 0, BI.getWidth(), BI.getHeight(), null);
        g2.dispose();
        return BI;
    }

    public JComponent ghostifyComponent(JComponent component) {
        BufferedImage BI = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        Graphics2D g2 = BI.createGraphics();
        component.paint(g2);
        BI.flush();
        final ImageIcon icon = new ImageIcon(BI);
        g2.dispose();
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                icon.paintIcon(this, g, 0, 0);
            }
        };
        panel.setPreferredSize(new Dimension(BI.getWidth(), BI.getHeight()));
        return panel;
    }

    public Image desaturate(Image image) {
        BufferedImage BI = new BufferedImage(image.getWidth(null), image.getHeight(null), 10);
        Graphics2D g2 = (Graphics2D)BI.getGraphics();
        g2.drawImage(image, 0, 0, BI.getWidth(), BI.getHeight(), null);
        g2.dispose();
        return BI;
    }

    public Image rescaleImage(Image image, double scaleFactor) {
        return this.rescaleImage(image, (int)((double)image.getWidth(null) * scaleFactor), (int)((double)image.getHeight(null) * scaleFactor));
    }

    public Image rescaleImage(Image image, int width, int height) {
        BufferedImage BI = new BufferedImage(width, height, 6);
        double scaleX = (double)width / (double)image.getWidth(null);
        double scaleY = (double)height / (double)image.getHeight(null);
        Graphics2D graphics = (Graphics2D)BI.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationRH);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAliasingRH);
        graphics.scale(scaleX, scaleY);
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return BI;
    }

    public Image rescaleImageByWidth(Image image, int width) {
        BufferedImage BI = new BufferedImage(width, image.getHeight(null), 6);
        double scaleX = (double)width / (double)image.getWidth(null);
        Graphics2D graphics = (Graphics2D)BI.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationRH);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAliasingRH);
        graphics.scale(scaleX, scaleX);
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return BI;
    }

    public Image fitImageTo(Image image, int maxWidth, int maxHeight) {
        double widthScale = (double)maxWidth / (double)image.getWidth(null);
        double heightScale = (double)maxHeight / (double)image.getHeight(null);
        if (heightScale < widthScale) {
            if (heightScale < 1.0) {
                return this.rescaleImage(image, heightScale);
            }
        } else if (widthScale < 1.0) {
            return this.rescaleImage(image, widthScale);
        }
        return image;
    }

    public Image cropImageToOneOneAspectRatio(Image image) {
        int height;
        int width = image.getWidth(null);
        if (width == (height = image.getHeight(null))) {
            return image;
        }
        BufferedImage img = new BufferedImage(Math.min(width, height), Math.min(width, height), 6);
        Graphics2D graphics = (Graphics2D)img.getGraphics();
        if (width > height) {
            graphics.drawImage(image, -(width - height) / 2, 0, null);
        } else {
            graphics.drawImage(image, 0, -(height - width) / 2, null);
        }
        graphics.dispose();
        return img;
    }

    public Image imposeImage(Image primaryImage, Image secondaryImage, double posX, double posY) {
        BufferedImage BI = new BufferedImage(primaryImage.getWidth(null), primaryImage.getHeight(null), 6);
        Graphics2D g2 = (Graphics2D)BI.getGraphics();
        g2.drawImage(primaryImage, 0, 0, null);
        g2.drawImage(secondaryImage, (int)(posX * (double)(BI.getWidth() - secondaryImage.getWidth(null))), (int)(posX * (double)(BI.getHeight() - secondaryImage.getHeight(null))), null);
        g2.dispose();
        return BI;
    }

    public byte[] shrinkToByteSize(Image value, int sizeInBytes, ImageFormat format) {
        byte[] data = null;
        double scale = 1.0;
        if (ImageFormat.PNG.equals((Object)format)) {
            this.antiAliasingRH = RenderingHints.VALUE_ANTIALIAS_OFF;
            this.interpolationRH = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        while (data == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream out = new MemoryCacheImageOutputStream(bout);
            RenderedImage renderedImage = value instanceof RenderedImage ? (RenderedImage)((Object)value) : (value instanceof ToolkitImage ? ((ToolkitImage)value).getBufferedImage() : (BufferedImage)value);
            try {
                if (scale == 1.0) {
                    ImageIO.write(renderedImage, format.name(), out);
                } else {
                    ImageIO.write((RenderedImage)((Object)this.rescaleImage((Image)((Object)renderedImage), scale)), format.name(), out);
                }
                bout.flush();
                bout.close();
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot write out bytes");
                return null;
            }
            data = bout.toByteArray();
            if (data.length <= sizeInBytes) continue;
            data = null;
            scale *= 0.85;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage readInFromBytes(byte[] imageData) {
        if (imageData == null || imageData.length < 2) {
            return null;
        }
        ByteArrayInputStream bin = null;
        BufferedImage image = null;
        try {
            bin = new ByteArrayInputStream(imageData);
            image = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot read in image from bytes", (Throwable)ex);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off byteArrayInputStream", (Throwable)ex);
                }
            }
        }
        return image;
    }

    public Image tintImage(Image toTint, Color tintColor, float tintFactor) {
        BufferedImage BI = new BufferedImage(toTint.getWidth(null), toTint.getHeight(null), 6);
        Graphics2D g2 = (Graphics2D)BI.getGraphics();
        g2.drawImage(toTint, 0, 0, null);
        ColorTintFilter tintOperation = new ColorTintFilter(tintColor, tintFactor);
        BufferedImage dest = tintOperation.createCompatibleDestImage(BI, null);
        dest = tintOperation.filter(BI, dest);
        return dest;
    }

    public Image roundCorners(Image image, int cornerRadius) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage output = new BufferedImage(width, height, 2);
        Graphics2D graphics = output.createGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.WHITE);
        graphics.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, cornerRadius, cornerRadius));
        graphics.setComposite(AlphaComposite.SrcAtop);
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return output;
    }

    public Object getInterpolationRH() {
        return this.interpolationRH;
    }

    public void setInterpolationRH(Object interpolationRH) {
        this.interpolationRH = interpolationRH;
    }

    public Object getAntiAliasingRH() {
        return this.antiAliasingRH;
    }

    public void setAntiAliasingRH(Object antiAliasingRH) {
        this.antiAliasingRH = antiAliasingRH;
    }

    public boolean[][] asTwoToneBitmap(RenderedImage image) {
        boolean[][] bits = new boolean[image.getHeight()][image.getWidth()];
        Raster data = image.getData();
        int[] rgba = new int[4];
        for (int row = 0; row < bits.length; ++row) {
            for (int col = 0; col < bits[0].length; ++col) {
                data.getPixel(col, row, rgba);
                bits[row][col] = rgba[0] < 150;
            }
        }
        return bits;
    }

    public char[] asTwoToneByteArray(RenderedImage image) {
        int height;
        int width = image.getWidth();
        int rows = height = image.getHeight();
        int cols = width / 8;
        if (width % 8 != 0) {
            ++cols;
        }
        char[] byteArray = new char[cols * rows];
        Raster data = image.getData();
        int[] rgba = new int[4];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int byteIndex = row * cols + col;
                byteArray[byteIndex] = '\u0000';
                for (int bit = 0; bit < 8; ++bit) {
                    int bitIndex = col * 8 + bit;
                    if (bitIndex >= width) continue;
                    data.getPixel(bitIndex, row, rgba);
                    if (rgba[0] >= 150) continue;
                    int n = byteIndex;
                    byteArray[n] = (char)(byteArray[n] | 128 >> bit);
                }
                System.out.print("" + byteArray[byteIndex] + " ");
            }
            System.out.println();
        }
        return byteArray;
    }

    public byte[][] asTwoToneByteArrayByteBanded(RenderedImage image) {
        int rows = image.getHeight();
        int bands = rows / 8;
        int cols = image.getWidth();
        ArrayList<byte[]> allBytes = new ArrayList<byte[]>();
        Raster data = image.getData();
        int[] rgba = new int[4];
        for (int band = 0; band < bands; ++band) {
            byte[] byteArray = new byte[cols];
            for (int col = 0; col < cols; ++col) {
                for (int bit = 0; bit < 8; ++bit) {
                    int row = band * 8 + bit;
                    data.getPixel(col, row, rgba);
                    if (rgba[0] >= 150) continue;
                    int n = col;
                    byteArray[n] = (byte)(byteArray[n] | 128 >> bit);
                }
            }
            allBytes.add(byteArray);
        }
        return (byte[][])allBytes.toArray((T[])new byte[allBytes.size()][]);
    }

    public byte[][] asTwoToneByteArrayByteBanded(RenderedImage image, int bytesPerBand) {
        int bits = 8;
        int rpb = bits * bytesPerBand;
        int rows = image.getHeight();
        int bands = rows / (bytesPerBand * bits) + 1;
        int cols = image.getWidth();
        ArrayList<byte[]> allBytes = new ArrayList<byte[]>();
        Raster data = image.getData();
        int[] rgba = new int[4];
        for (int band = 0; band < bands; ++band) {
            byte[] byteArray = new byte[cols * bytesPerBand];
            for (int col = 0; col < cols; ++col) {
                for (int bandByte = 0; bandByte < bytesPerBand; ++bandByte) {
                    for (int bit = 0; bit < 8; ++bit) {
                        int row = bandByte * 8 + band * rpb + bit;
                        if (row >= rows) continue;
                        data.getPixel(col, row, rgba);
                        if (rgba[0] >= 150) continue;
                        int n = col * bytesPerBand + bandByte;
                        byteArray[n] = (byte)(byteArray[n] | 128 >> bit);
                    }
                }
            }
            allBytes.add(byteArray);
        }
        return (byte[][])allBytes.toArray((T[])new byte[allBytes.size()][]);
    }

    public RenderedImage removeAlpha(Image image, Color replaceWith) {
        BufferedImage BI = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        Graphics2D g2 = (Graphics2D)BI.getGraphics();
        g2.drawImage(image, 0, 0, replaceWith, null);
        return BI;
    }
}

