/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.image;

import au.com.ordermate.util.image.FragmentedGif;
import com.sun.imageio.plugins.gif.GIFImageMetadata;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class ImageResizeHelper {
    public ImageIcon rescaleImageIcon(ImageIcon imageIcon, double scaleFactor, int scalingAlgorithm) {
        double scaledWidth = Math.max((double)imageIcon.getIconWidth() * scaleFactor, 1.0);
        double scaledHeight = Math.max((double)imageIcon.getIconHeight() * scaleFactor, 1.0);
        if (scaledWidth <= 0.0 || scaledHeight <= 0.0) {
            return imageIcon;
        }
        return new ImageIcon(imageIcon.getImage().getScaledInstance((int)scaledWidth, (int)scaledHeight, scalingAlgorithm));
    }

    public ImageIcon rescaleImageIcon(ImageIcon imageIcon, double scaleFactor) {
        return this.rescaleImageIcon(imageIcon, scaleFactor, 1);
    }

    public FragmentedGif rescaleGif(FragmentedGif gif, double scaleFactor, int scalingAlgorithm) {
        FragmentedGif resizedGif = new FragmentedGif();
        for (int i = 0; i < gif.getFrames().size(); ++i) {
            BufferedImage before = gif.getFrames().get(i);
            GIFImageMetadata metadata = (GIFImageMetadata)gif.getFrameMetadata().get(i);
            int w = (int)Math.ceil((double)before.getWidth() * scaleFactor);
            int h = (int)Math.ceil((double)before.getHeight() * scaleFactor);
            ImageIcon frameIcon = new ImageIcon(before);
            BufferedImage after = new BufferedImage(w, h, 2);
            Graphics2D g = after.createGraphics();
            this.rescaleImageIcon(frameIcon, scaleFactor, scalingAlgorithm).paintIcon(null, g, 0, 0);
            g.dispose();
            GIFImageMetadata newMeta = this.copyMetadata(metadata);
            newMeta.imageTopPosition = (int)Math.ceil(scaleFactor * (double)metadata.imageTopPosition);
            newMeta.imageLeftPosition = (int)Math.ceil(scaleFactor * (double)metadata.imageLeftPosition);
            newMeta.imageWidth = (int)Math.ceil(scaleFactor * (double)metadata.imageWidth);
            newMeta.imageHeight = (int)Math.ceil(scaleFactor * (double)metadata.imageHeight);
            resizedGif.addFrame(after, newMeta);
        }
        return resizedGif;
    }

    public FragmentedGif rescaleGif(FragmentedGif gif, double scaleFactor) {
        return this.rescaleGif(gif, scaleFactor, 1);
    }

    private GIFImageMetadata copyMetadata(GIFImageMetadata from) {
        GIFImageMetadata to = new GIFImageMetadata();
        to.imageTopPosition = from.imageTopPosition;
        to.imageLeftPosition = from.imageLeftPosition;
        to.imageWidth = from.imageWidth;
        to.imageHeight = from.imageHeight;
        to.interlaceFlag = from.interlaceFlag;
        to.sortFlag = from.sortFlag;
        to.localColorTable = from.localColorTable;
        to.disposalMethod = from.disposalMethod;
        to.userInputFlag = from.userInputFlag;
        to.transparentColorFlag = from.transparentColorFlag;
        to.delayTime = from.delayTime;
        to.transparentColorIndex = from.transparentColorIndex;
        to.hasPlainTextExtension = from.hasPlainTextExtension;
        to.textGridLeft = from.textGridLeft;
        to.textGridTop = from.textGridTop;
        to.textGridWidth = from.textGridWidth;
        to.textGridHeight = from.textGridHeight;
        to.characterCellWidth = from.characterCellWidth;
        to.characterCellHeight = from.characterCellHeight;
        to.textForegroundColor = from.textForegroundColor;
        to.textBackgroundColor = from.textBackgroundColor;
        to.text = from.text;
        to.applicationIDs = from.applicationIDs;
        to.authenticationCodes = from.authenticationCodes;
        to.applicationData = from.applicationData;
        to.comments = from.comments;
        return to;
    }
}

