/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.macaddr;

import au.com.ordermate.util.ProcessUtil;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.macaddr.MacAddressDetails;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;

public class MacAddressFromSystem {
    private final List<MacAddressDetails> macAddresses = new ArrayList<MacAddressDetails>();

    public MacAddressFromSystem() {
        this.copyExecutableFromOrdermateJar();
        this.runScript();
        this.readInResults();
    }

    private void copyExecutableFromOrdermateJar() {
        File exeFile;
        File tempDir = new File("C:\\Temp");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        if (!(exeFile = new File("C:\\Temp\\MacAddressBySystem.exe")).exists()) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/MacAddressBySystem.exe");
                int input = 0;
                FileOutputStream fout = new FileOutputStream(exeFile);
                while ((input = inputStream.read()) != -1) {
                    fout.write(input);
                }
                fout.flush();
                fout.close();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Could not find MacAddressBySystem.exe in ordermate-pos.jar", (Throwable)ex);
            }
        }
    }

    private void runScript() {
        try {
            ProcessUtil.runCmdAndWait("C:\\Temp\\MacAddressBySystem.exe");
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Exception occurred while trying to retrieve MAC Address via MacAddressBySystem.exe", (Throwable)ex);
        }
    }

    private void readInResults() {
        String textFile = "";
        try {
            textFile = StringUtils.readInTextFile("C:\\Temp\\mac-address.txt");
        }
        catch (IOException e) {
            OrderMate.LOG.warn("Failed to read in MAC address list from C:\\temp\\mac-address.txt!");
            return;
        }
        List<String> lines = StringUtils.splitToList(textFile, "\r\n");
        for (String line : lines) {
            String macAddress = this.getMacAddress(line);
            String adapterName = this.getAdapterName(line);
            this.macAddresses.add(new MacAddressDetails(macAddress, adapterName));
        }
    }

    private String getMacAddress(String line) {
        String[] attributes = line.split("::");
        String[] macAttribute = attributes[1].split(":-:");
        return macAttribute[1];
    }

    private String getAdapterName(String line) {
        String[] attributes = line.split("::");
        if (attributes.length < 7) {
            return "";
        }
        return attributes[7].substring("AdapterName: ".length());
    }

    public List<String> getMacAddressFromSystem() {
        ArrayList<String> macAddressList = new ArrayList<String>();
        for (MacAddressDetails details : this.macAddresses) {
            macAddressList.add(details.getMacAddress());
        }
        return macAddressList;
    }

    public List<MacAddressDetails> getAllNetworkAdapters() {
        return this.macAddresses;
    }
}

