/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.util.maps;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.maps.ITypeMap;
import java.util.Iterator;
import java.util.Map;

abstract class TypeMap
implements ITypeMap {
    private Map<String, Map<Object, Object>> typeMap = this.getTypeMap();

    protected abstract Map<Object, Object> getNewObjectMap();

    protected abstract Map<String, Map<Object, Object>> getTypeMap();

    public TypeMap() {
        this.getNewObjectMap();
    }

    private Map<Object, Object> getObjectMapForType(Class type) {
        Map<Object, Object> map = this.typeMap.get(type.getName());
        if (map == null) {
            map = this.getNewObjectMap();
            this.typeMap.put(type.getName(), map);
        }
        return map;
    }

    @Override
    public final void put(Class type, Object key, Object object) {
        if (object != null && key != null) {
            this.getObjectMapForType(type).put(key, object);
        } else if (key != null) {
            this.getObjectMapForType(type).remove(key);
        } else {
            OrderMateLog.LOG.warn("Attempt to put null key into hash map with object : " + object + " of type :" + type);
        }
    }

    @Override
    public final Object get(Class type, Object key) {
        return this.getObjectMapForType(type).get(key);
    }

    @Override
    public final boolean containsKey(Class type, Object key) {
        return this.get(type, key) != null;
    }

    @Override
    public final void clear() {
        Iterator<String> it = this.typeMap.keySet().iterator();
        while (it.hasNext()) {
            Map<Object, Object> currentMap = this.typeMap.get(it.next());
            currentMap.clear();
        }
        this.typeMap.clear();
    }

    @Override
    public final void clearTypeMap(Class type) {
        this.getObjectMapForType(type).clear();
    }

    @Override
    public final void remove(Class type, Object key) {
        this.getObjectMapForType(type).remove(key);
    }
}

