/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.version;

import au.com.ordermate.version.OMVersion;
import au.com.ordermate.version.VersionStability;
import ordermate.OrderMate;

public class VersionWrangler {
    public OMVersion wrangleVersion(String versionString) {
        if (versionString == null || versionString.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot have a null or empty version String");
        }
        String substring = versionString.trim();
        if (!this.checkValidity(substring)) {
            throw new IllegalArgumentException("Version is not of the correct form! " + substring);
        }
        String[] splits = substring.split("\\.");
        int major = this.wrangleMajor(splits);
        int subMajor = this.wrangleSubMajor(splits);
        int minor = this.wrangleMinor(splits);
        VersionStability stability = this.wrangleStability(splits);
        String revision = this.wrangleRevision(splits, stability);
        return new OMVersion(major, subMajor, minor, stability, revision);
    }

    public boolean checkValidity(String toCheck) {
        String[] splits = toCheck.split("\\.");
        if (splits.length < 3) {
            OrderMate.LOG.warn("We must have two periods for a proper version.");
            return false;
        }
        for (char nextChar : splits[0].toCharArray()) {
            if (Character.isDigit(nextChar)) continue;
            OrderMate.LOG.warn("Major Version must be a digit");
            return false;
        }
        for (char nextChar : splits[1].toCharArray()) {
            if (Character.isDigit(nextChar)) continue;
            OrderMate.LOG.warn("SubMajor Version must be a digit");
            return false;
        }
        if (!Character.isDigit(splits[2].charAt(0))) {
            OrderMate.LOG.warn("Minor Version must be a digit");
            return false;
        }
        if (splits[2].length() < 2) {
            OrderMate.LOG.warn("Revision or stability cannot be empty");
            return false;
        }
        return true;
    }

    private int wrangleMajor(String[] versionString) {
        return Integer.parseInt(versionString[0]);
    }

    private int wrangleSubMajor(String[] versionString) {
        return Integer.parseInt(versionString[1]);
    }

    private int wrangleMinor(String[] versionString) {
        char[] chars = versionString[2].toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return Integer.parseInt(versionString[2].substring(0, i));
        }
        return Integer.parseInt(versionString[2]);
    }

    private VersionStability wrangleStability(String[] versionString) {
        int indexOfChar = -1;
        int lastChar = 0;
        char[] chars = versionString[2].toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (indexOfChar == -1) {
                if (!Character.isDigit(chars[i]) && !Character.isWhitespace(chars[i])) {
                    indexOfChar = i;
                }
            } else if (Character.isDigit(chars[i])) {
                lastChar = i;
                break;
            }
            lastChar = i + 1;
        }
        if (indexOfChar < 0) {
            return VersionStability.Banana;
        }
        String finalString = versionString[2].substring(indexOfChar, lastChar).trim();
        if (VersionStability.Dev.getLabel().equalsIgnoreCase(finalString)) {
            return VersionStability.Dev;
        }
        if (VersionStability.Beta.getLabel().equalsIgnoreCase(finalString)) {
            return VersionStability.Beta;
        }
        if (VersionStability.ReleaseCandidate.getLabel().equalsIgnoreCase(finalString)) {
            return VersionStability.ReleaseCandidate;
        }
        if (finalString.length() < 3 && finalString.length() > 0) {
            boolean allLetters = true;
            for (int i = 0; i < finalString.length(); ++i) {
                if (!Character.isDigit(finalString.charAt(i))) continue;
                allLetters = false;
            }
            if (allLetters) {
                return VersionStability.Stable;
            }
        }
        return VersionStability.Banana;
    }

    private String wrangleRevision(String[] versionString, VersionStability stability) {
        int indexOfChar = 0;
        char[] chars = versionString[2].toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i]) || Character.isWhitespace(chars[i])) continue;
            indexOfChar = i;
            break;
        }
        String finalString = versionString[2].substring(indexOfChar);
        if (VersionStability.Beta.equals((Object)stability) || VersionStability.ReleaseCandidate.equals((Object)stability)) {
            chars = finalString.toCharArray();
            int index = chars.length - 1;
            int i = chars.length - 1;
            while (i >= 0 && Character.isDigit(chars[i])) {
                index = i--;
            }
            return finalString.substring(index);
        }
        return finalString;
    }
}

