/*
 * Decompiled with CFR 0.152.
 */
package ordermate;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CacheManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.integration.PropertyIntegrationUtils;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.integration.bartabs.BarTabAdministrator;
import ordermate.scheduler.Scheduler;
import ordermate.services.finance.tradingday.UpdateTradingDayCallable;
import ordermate.services.finance.tradingday.UpdateTradingDayRetriableTask;

public class ChangeDayTask {
    static final int MAX_WAIT_TIME = 5;
    static final int TIME_PER_TERMINAL = 1;
    private static final int STALE_DOCKET_DAYS = -7;

    private ChangeDayTask() {
    }

    public static void schedule() {
        TradingDay current = TradingDay.getCurrentTradingDay();
        Date changeTime = TradingDay.getChangeOfDayTime(current.getDate(), SystemProperty.getInstance().getChangeDayTime());
        if (TradingDay.needsNewTradingDay()) {
            throw new RuntimeException("Change of day cannot be scheduled as the trading day is not current");
        }
        Timer theTimer = new Timer(true);
        theTimer.schedule((TimerTask)new ChangeDayRunner(), changeTime);
    }

    public static void changeDay(User changeDayUser, Terminal changeDayTerm) {
        OrderMate.LOG.info("Executing change of Day");
        try {
            BarTabAdministrator.getInstance().closeAllAccountsForVendorEndOfTradingDay();
            ChangeDayTask.resetUpdateCount();
            ChangeDayTask.synchronizeIntegrations();
            ChangeDayTask.revertTablePositions();
            ChangeDayTask.revertOnlineAccountEta();
            ChangeDayTask.resetCashDrawerAssignments();
            ChangeDayTask.exportZReads();
            ChangeDayTask.resetDockets();
            ChangeDayTask.clearCache();
            System.gc();
        }
        catch (Throwable t) {
            OrderMate.LOG.error("An error has occurred during preliminary change of day setup", t);
        }
        TradingDay closingDay = TradingDay.getCurrentTradingDay();
        ChangeDayTask.createNewTradingDay(changeDayUser, changeDayTerm);
        ChangeDayTask.updateTerminalShift();
        ChangeDayTask.updateTerminals();
        PersistenceManager.getInstance().clearLocalCaches();
        OrderMate.LOG.info("Change of day complete");
        Scheduler.getInstance().runTradingDay(closingDay);
        SystemCurrentInfo.setUpdate("Change day task");
    }

    private static void updateTerminalShift() {
        Terminal servermate = Terminal.getServerMateTerminal();
        servermate = (Terminal)PersistenceManager.reacquire(servermate);
        servermate.changeShift(Shift.getFirstShiftForDate(new Date()));
        PersistenceManager.save(servermate);
        Terminal.setupServerMate(servermate);
    }

    private static void updateTerminals() {
        List<Terminal> wmTerminals = Terminal.getAllWaiterMateTerminals();
        ArrayList<UpdateTradingDayRetriableTask> retriableTasks = new ArrayList<UpdateTradingDayRetriableTask>();
        OrderMate.LOG.info("Updating Terminals for Trading Day change .. ");
        for (Terminal wmTerminal : wmTerminals) {
            UpdateTradingDayRetriableTask retriable = new UpdateTradingDayRetriableTask(new UpdateTradingDayCallable(wmTerminal));
            retriableTasks.add(retriable);
        }
        ExecutorService service = Executors.newFixedThreadPool(retriableTasks.size());
        try {
            List<Future<String>> futures = service.invokeAll(retriableTasks, ChangeDayTask.getWaitTime(retriableTasks.size()), TimeUnit.MINUTES);
            ChangeDayTask.logResults(futures);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.error("Failed to update trading day of terminals!", (Throwable)e);
        }
        OrderMate.LOG.info("Completed Trading Day update for terminals");
    }

    private static long getWaitTime(int taskCount) {
        return Math.min(taskCount * 1, 5);
    }

    private static void logResults(List<Future<String>> futures) {
        for (Future<String> future : futures) {
            try {
                OrderMate.LOG.info(future.get());
            }
            catch (Exception e) {
                OrderMate.LOG.error((Object)e);
            }
        }
    }

    private static void createNewTradingDay(User changeDayUser, Terminal changeDayTerm) {
        OrderMate.LOG.info("Creating New Trading Day");
        TradingDay.createTradingDay(changeDayUser, changeDayTerm);
    }

    private static void revertTablePositions() {
        if (SystemProperty.getInstance().isTablePositionsRevert()) {
            OrderMate.LOG.info("Reverting to saved table positions");
            List<TableGroup> tableGroups = TableGroupQueries.getTableGroups();
            for (TableGroup tableGroup : tableGroups) {
                tableGroup.getHelper().restorePermanentPositions();
                tableGroup.save();
            }
        }
    }

    private static void synchronizeIntegrations() {
        ReservationIntegrationUtils.clearReservations();
        ReservationIntegrationUtils.synchronize();
        PropertyIntegrationUtils.synchronize();
    }

    private static void exportZReads() {
        PropertyIntegrationUtils.writeZReads();
    }

    private static void revertOnlineAccountEta() {
        for (OnlineIntegrationETA eta : OnlineIntegrationETA.getAllETAs()) {
            eta.setCurrentETA(eta.getDefaultETA());
            eta.save();
        }
    }

    private static void resetCashDrawerAssignments() {
        try {
            OrderMate.LOG.info("Resetting assigned cashdrawers");
            Data.database.resetCashDrawerAssignments();
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public static void resetDockets() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        Date end = cal.getTime();
        cal.add(5, -7);
        Date start = cal.getTime();
        String deleteNonFinanceDockets = "DELETE FROM system_docket WHERE class_type <> '" + AbstractDocket.DocketClassType.FINANCE_TRANSACTION.getLabel() + "' AND creation_time BETWEEN ? AND ?";
        PersistenceManager.getPersistenceDelegate().executeUpdate(deleteNonFinanceDockets, new Object[]{start, end});
        List<VirtualPrinter> printers = VirtualPrinter.getAllPrinters();
        for (VirtualPrinter printer : printers) {
            printer.resetDocketNumber();
        }
    }

    private static void clearCache() {
        CacheManager.getInstance().clearEntireCache();
        PersistenceManager.getInstance().clearLocalCaches();
    }

    public static void resetUpdateCount() {
        TableGroup.resetReloadNums();
    }

    private static class ChangeDayRunner
    extends TimerTask {
        private ChangeDayRunner() {
        }

        @Override
        public void run() {
            ChangeDayTask.changeDay(User.getSystemUser(), Terminal.getServerMateTerminal());
            ChangeDayTask.schedule();
        }
    }
}

