/*
 * Decompiled with CFR 0.152.
 */
package ordermate;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.WindowsUtils;
import java.util.List;
import ordermate.LogoffCallback;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;

public class LogoutLocalWM {
    private GuiHandler gui;

    public LogoutLocalWM(GuiHandler gui) {
        this.gui = gui;
    }

    public void start() {
        List<Terminal> wmTerminals = PersistenceManager.getObjectList(Terminal.class, Query.select(Terminal.class).active(Terminal.class).not().isNull(Terminal.Properties.USERNAME).toString());
        if (wmTerminals.isEmpty()) {
            this.gui.displayOkDialog("No Terminals", "There are no local Waitermate Terminals configured to log off.");
            return;
        }
        final Terminal choice = (Terminal)this.gui.displayChoiceDialog("Choose the Terminal", "This will log the selected user off the ServerMate terminal.", wmTerminals, null);
        if (choice != null) {
            OrderMate.LOG.info("Got signal to logout " + choice + " from Servermate of username " + choice.getUsername());
            Thread logoffThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    LogoffCallback callback = new LogoffCallback(){

                        @Override
                        public void onLogoffResult(boolean success) {
                            if (success) {
                                LogoutLocalWM.this.gui.displayOkDialog("Logoff Success", choice + " was logged off successfully.");
                            } else {
                                LogoutLocalWM.this.gui.displayOkDialog("Logoff Unsuccessful", choice + " may not have been logged off");
                            }
                        }
                    };
                    WindowsUtils.safeLogoffUser(choice.getUsername(), callback);
                }
            });
            logoffThread.start();
        }
    }
}

