/*
 * Decompiled with CFR 0.152.
 */
package ordermate;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.image.IconLoader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import ordermate.services.hardware.physical.eftpos.CashDrawerManager;

public class SafeRestartTask
extends AbstractTask {
    private boolean openCashdraws;
    private boolean printAllOpenedAccount;
    private List allAccounts;
    private User loginedUser;

    @Override
    public int getTotalSubTasks() {
        List<Terminal> terminalList = Terminal.getAllWaiterMateTerminals();
        List<CashDrawer> cashDrawerList = Terminal.getLocalHost().getPayableCashDrawers(this.loginedUser);
        if (this.allAccounts == null) {
            this.allAccounts = Account.getAllOpenCurrentDayAccount();
        }
        return this.allAccounts.size() + terminalList.size() + cashDrawerList.size();
    }

    @Override
    public String getName() {
        return "Safe Rebooting...";
    }

    @Override
    public Icon getIcon() {
        return IconLoader.get("/ordermate/images/warning.png");
    }

    public void actions(boolean cashDraws, boolean openedAccount, User user) {
        this.openCashdraws = cashDraws;
        this.printAllOpenedAccount = openedAccount;
        this.loginedUser = user;
    }

    @Override
    protected void performTask() throws Exception {
        if (this.openCashdraws) {
            this.printAllOpenAccounts();
        }
        if (this.printAllOpenedAccount) {
            this.openAllCashDrawers();
        }
        this.restarting();
    }

    private void printAllOpenAccounts() {
        if (!this.allAccounts.isEmpty()) {
            List<Terminal> terminalList = Terminal.getAllWaiterMateTerminals();
            Iterator<Terminal> it = terminalList.iterator();
            try {
                while (it.hasNext()) {
                    Terminal terminal = it.next();
                    Iterator pit = this.allAccounts.iterator();
                    while (pit.hasNext()) {
                        Account account = (Account)pit.next();
                        try {
                            account.printReceiptDockets(this.loginedUser, terminal);
                            this.emitProgress();
                        }
                        catch (Exception e1) {
                            String msg = "Unable to print account (ID = " + account.getID() + ")";
                            OrderMate.LOG.error(msg, (Throwable)e1);
                        }
                        if (!pit.hasNext()) continue;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e3) {
                            OrderMate.LOG.info("Interrupted while waiting", (Throwable)e3);
                        }
                    }
                }
            }
            catch (Exception e2) {
                OrderMate.LOG.error("Unable to print open account", (Throwable)e2);
            }
        } else {
            OrderMate.LOG.info("There is no open account.");
        }
    }

    private void openAllCashDrawers() {
        List<Terminal> terminalList = Terminal.getAllWaiterMateTerminals();
        for (Terminal terminal : terminalList) {
            if (terminal.getConnectedCashDrawers().isEmpty()) continue;
            try {
                CashDrawerManager.getInstance().openAllCashDrawersNoSale(this.loginedUser, terminal);
                this.emitProgress();
            }
            catch (Exception e1) {
                OrderMate.LOG.error("Unable to open cash draws", (Throwable)e1);
            }
        }
    }

    private void restarting() {
        TerminalEventLog.logSafeRestart(this.loginedUser);
        LinkedHashSet<Terminal> terminalSet = new LinkedHashSet<Terminal>(Terminal.getAllWaiterMateTerminals());
        terminalSet.remove(Terminal.getServerMateTerminal());
        terminalSet.add(Terminal.getServerMateTerminal());
        for (Terminal terminal : terminalSet) {
            this.callShutdownRuntime(terminal, "posman12");
            this.callShutdownRuntime(terminal, "Posman12");
        }
    }

    private void callShutdownRuntime(Terminal terminal, String pass) {
        try {
            Runtime.getRuntime().exec("C:\\windows\\psshutdown \\\\" + terminal.getName() + " -f -r -t 25 -m \"OrderMate Shutdown\" -u Administrator -p " + pass);
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Error during shutting down terminals " + terminal.getName() + ".", (Throwable)ex);
        }
    }
}

