/*
 * Decompiled with CFR 0.152.
 */
package ordermate.action;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.action.ActionProcessor;
import ordermate.action.ConfigActionTask;
import ordermate.database.EventContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.action.ActionFireOn;
import ordermate.database.misc.action.ConfigAccountAction;
import ordermate.database.misc.action.ConfigAction;
import ordermate.database.misc.action.ConfigTimerAction;

public class ActionManager {
    private static ActionManager instance;
    private Gateway<ConfigActionTask> gate;
    private List<ConfigAccountAction> triggeredActions;
    private List<ConfigTimerAction> timedActions;
    private boolean usesTimer = false;
    private Timer timer;

    public static final ActionManager getInstance() {
        return instance;
    }

    public static final void init(boolean useTimer, GuiHandler ui) {
        if (instance != null) {
            throw new IllegalStateException("There can be only one ActionManager.");
        }
        instance = new ActionManager(useTimer, ui);
    }

    private ActionManager(boolean useTimer, GuiHandler ui) {
        this.usesTimer = useTimer;
        ActionProcessor processor = new ActionProcessor(ui);
        this.gate = new Gateway<ConfigActionTask>(processor, processor);
        this.reloadActions();
        this.gate.startService();
    }

    public synchronized void reloadActions() {
        this.triggeredActions = PersistenceManager.getObjectList(ConfigAccountAction.class, Query.select(ConfigAccountAction.class).toString());
        this.timedActions = PersistenceManager.getObjectList(ConfigTimerAction.class, Query.select(ConfigTimerAction.class).toString());
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.usesTimer && this.timedActions != null) {
            this.timer = new Timer("Action Timer");
            for (ConfigTimerAction nextTimer : this.timedActions) {
                this.timer.schedule((TimerTask)new ActionTimerTask(nextTimer), nextTimer.getTimerSeconds() * 1000, (long)(nextTimer.getTimerSeconds() * 1000));
            }
        }
    }

    public synchronized void gotAction(ConfigActionTask actionTask) {
        this.gate.putIntoQueue(actionTask);
    }

    public synchronized void triggerAction(ActionFireOn firedOn, TriggerActivationContext activationContext) {
        if (this.triggeredActions.isEmpty()) {
            return;
        }
        for (ConfigAccountAction nextAction : this.triggeredActions) {
            if (!nextAction.getFireOn().equals((Object)firedOn) || !nextAction.isActive(activationContext)) continue;
            this.gotAction(new ConfigActionTask(nextAction, activationContext, false));
        }
    }

    List<ConfigTimerAction> getTimedActions() {
        return this.timedActions;
    }

    List<ConfigAccountAction> getTriggeredActions() {
        return this.triggeredActions;
    }

    class ActionTimerTask
    extends TimerTask {
        private final ConfigAction action;

        ActionTimerTask(ConfigAction theAction) {
            this.action = theAction;
        }

        @Override
        public void run() {
            TriggerActivationContext context = new TriggerActivationContext(new EventContext(null));
            if (this.action.isActive(context)) {
                ActionManager.this.gotAction(new ConfigActionTask(this.action, context, false));
            }
        }
    }
}

