/*
 * Decompiled with CFR 0.152.
 */
package ordermate.action;

import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.gui.GuiHandler;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.action.ActionHandler;
import ordermate.action.ConfigActionTask;
import ordermate.action.url.UrlActionHandler;
import ordermate.database.misc.action.ConfigAccountAction;
import ordermate.database.misc.action.ConfigAction;

public class ActionProcessor
implements GatewayProcessor<ConfigActionTask>,
GatewayNotifier<ConfigActionTask> {
    private Map<Class<? extends ConfigAction>, ActionHandler> handlerMap = new HashMap<Class<? extends ConfigAction>, ActionHandler>();
    private GuiHandler ui;
    private JPanel blocker;

    public ActionProcessor(GuiHandler ui) {
        this.ui = ui;
        this.handlerMap.put(ConfigAction.class, new UrlActionHandler());
        this.handlerMap.put(ConfigAccountAction.class, new UrlActionHandler());
    }

    @Override
    public void notifyProcess(ConfigActionTask processedValue, boolean processSuccessful) {
        if (this.ui != null && processedValue.block) {
            this.ui.closeBlockingDialog(this.blocker);
            this.blocker = null;
            if (processSuccessful) {
                this.ui.displayOkDialog(processedValue.action.getLabel(), "Successful");
            } else {
                this.ui.displayOkDialog(processedValue.action.getLabel(), "Failed. Please see logs.");
            }
        }
    }

    @Override
    public boolean processIncoming(final ConfigActionTask toProcess) {
        if (toProcess == null) {
            return true;
        }
        OrderMate.LOG.info("Processing action:" + toProcess.action.getLabel());
        ActionHandler handler = this.getHandler(toProcess.action.getClass());
        if (this.ui != null && toProcess.block) {
            if (this.blocker != null) {
                this.ui.closeBlockingDialog(this.blocker);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ActionProcessor.this.blocker = new JPanel(new GridLayout(2, 1));
                        JProgressBar bar = new JProgressBar();
                        bar.setPreferredSize(new Dimension(200, 50));
                        bar.setIndeterminate(true);
                        ActionProcessor.this.blocker.add(new JLabel("Calling " + toProcess.action.getLabel()));
                        ActionProcessor.this.blocker.add(bar);
                    }
                });
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Couldn't create a blocking panel", (Throwable)ex);
            }
            this.ui.displayBlockingDialog(this.blocker);
        }
        return handler.performAction(toProcess.action, toProcess.context);
    }

    private ActionHandler getHandler(Class<? extends ConfigAction> clazz) {
        ActionHandler handler = this.handlerMap.get(clazz);
        if (handler == null) {
            handler = this.handlerMap.get(ConfigAction.class);
        }
        return handler;
    }
}

