/*
 * Decompiled with CFR 0.152.
 */
package ordermate.action.url;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.util.Pair;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import ordermate.action.url.ActionPushHandler;
import ordermate.database.EventContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.action.ActionHelper;
import ordermate.database.misc.action.ConfigAction;
import ordermate.database.users.User;
import ordermate.integration.webservice.RestHelper;

abstract class AbstractPushHandler
implements ActionPushHandler {
    final ConfigAction action;
    final ActionHelper actionHelper = new ActionHelper();
    final TriggerActivationContext context;

    AbstractPushHandler(ConfigAction yourAction, TriggerActivationContext theContext) {
        this.action = yourAction;
        this.context = theContext == null ? new TriggerActivationContext(new EventContext(User.getSystemUser())) : theContext;
    }

    @Override
    public void push() {
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getResource(this.action.getUrl());
        if (this.action.getWebConfig().getUsername() != null) {
            resource = helper.addBasicAuth(resource, this.action.getWebConfig().getUsername(), this.action.getWebConfig().getPassword());
        }
        List<List<Operator>> operators = this.getOperators();
        List<Pair<String, Object>> pairs = this.actionHelper.getPayloadPairs(this.context, operators);
        resource = this.modifyParameters(resource, helper, pairs);
        Object entity = this.createEntity(pairs);
        if (entity != null) {
            resource.method(this.getMethod(), entity);
        } else {
            resource.method(this.getMethod());
        }
    }

    List<List<Operator>> getOperators() {
        List<List<Operator>> ops = this.action.getPayloadOperators();
        if (ops == null) {
            ops = this.actionHelper.decipherPayload(this.action.getPayload());
            this.action.setPayloadOperators(ops);
        }
        return ops;
    }

    abstract Object createEntity(List<Pair<String, Object>> var1);

    abstract String getMethod();

    abstract WebResource modifyParameters(WebResource var1, RestHelper var2, List<Pair<String, Object>> var3);
}

