/*
 * Decompiled with CFR 0.152.
 */
package ordermate.audio;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.UnsupportedAudioFileException;
import ordermate.OrderMate;

public class AudioUtils {
    public static AudioInputStream getStreamFromUrl(String soundClip) {
        AudioInputStream audio = null;
        try {
            audio = AudioSystem.getAudioInputStream(new URL(soundClip));
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot play audio file:" + soundClip, (Throwable)ex);
        }
        catch (UnsupportedAudioFileException ex) {
            OrderMate.LOG.warn("Unsupported audio file:" + soundClip, (Throwable)ex);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot play audio file:" + soundClip, (Throwable)ex);
        }
        return audio;
    }

    public static AudioInputStream getStream(Class clazz, String soundClip) {
        AudioInputStream audio = null;
        try {
            audio = AudioSystem.getAudioInputStream(clazz.getResource(soundClip));
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot stream audio file:" + soundClip, (Throwable)ex);
        }
        catch (UnsupportedAudioFileException ex) {
            OrderMate.LOG.warn("Unsupported audio file:" + soundClip, (Throwable)ex);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot stream audio file:" + soundClip, (Throwable)ex);
        }
        return audio;
    }

    public static boolean playClip(AudioInputStream audio) {
        if (audio != null) {
            try {
                final Clip clip = AudioSystem.getClip();
                clip.addLineListener(new LineListener(){

                    @Override
                    public void update(LineEvent event) {
                        if (LineEvent.Type.STOP.equals(event.getType())) {
                            clip.close();
                        }
                    }
                });
                clip.open(audio);
                clip.start();
                return true;
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot play sound file.", (Throwable)ex);
            }
        }
        return false;
    }
}

