/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.oquery.ObjectQuery;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;

public abstract class AbstractDatabaseService
extends UnicastRemoteObject
implements Remote {
    protected DBConnectionInterface dc;
    private static boolean throwExceptions = false;
    private static final Object mutex = new Object();

    public static void setThrowExceptions(boolean throwEm) {
        throwExceptions = throwEm;
    }

    protected AbstractDatabaseService(DBConnectionInterface dbControl) throws RemoteException {
        this.dc = dbControl;
    }

    protected static final Object getMutex() {
        return mutex;
    }

    protected void handleSQLError(SQLException e, ObjectQuery query) {
        OrderMate.LOG.error("SQL Error in DBS \nQuery:\n" + query, (Throwable)e);
        if (throwExceptions) {
            throw new RuntimeException(e);
        }
    }

    public void handleSQLError(SQLException e) {
        OrderMate.LOG.error("SQL Error in DBS", (Throwable)e);
        if (throwExceptions) {
            throw new RuntimeException(e);
        }
    }

    protected void assertNotNull(Object toCheck, ObjectQuery sql) {
        if (toCheck == null) {
            String message = "Unexpected null result from SQL: " + sql;
            OrderMate.LOG.error(message + '\n', (Throwable)new IllegalStateException());
        }
    }

    protected void assertNotZero(int toCheck, ObjectQuery sql) {
        this.assertNot(toCheck, 0L, sql);
    }

    protected void assertNot(long toCheck, long notNumber, ObjectQuery sql) {
        if (toCheck == notNumber) {
            String message = "Unexpected result equal to " + notNumber + " from SQL: " + sql.toString();
            OrderMate.LOG.error(message + '\n', (Throwable)new IllegalStateException());
        }
    }

    protected synchronized boolean delete(String table, long ID) {
        return this.delete(table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean delete(String table, String[] whereConditions) {
        String sql = "DELETE FROM " + table;
        sql = sql + this.getWhereClause(whereConditions);
        boolean result = false;
        try {
            this.dc.execute(sql);
            result = true;
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return result;
    }

    protected synchronized boolean setToNull(String col, String table, long ID) {
        String sql = "UPDATE " + table + " SET " + col + " = NULL WHERE ID = " + ID;
        return this.execute(sql);
    }

    protected synchronized boolean setString(String col, String val, String table, long ID) {
        return this.setString(col, val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setString(String col, String val, String table, String[] whereConditions) {
        String sql = "UPDATE " + table + " SET " + col + " = '" + val + "'";
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized boolean setBool(String col, boolean val, String table, long ID) {
        return this.setBool(col, val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setBool(String col, boolean val, String table, String[] whereConditions) {
        String sql = "UPDATE " + table + " SET " + col + " = " + (val ? 1 : 0);
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized boolean setFKLink(String col, long val, String table, long ID) {
        return this.setFKLink(col, val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setFKLink(String col, long val, String table, String[] whereConditions) {
        String idString = val == 0L ? "NULL" : String.valueOf(val);
        String sql = "UPDATE " + table + " SET " + col + " = " + idString;
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized boolean setDate(String col, Date val, String table, long ID) {
        return this.setDate(col, val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setDate(String col, Date val, String table, String[] whereConditions) {
        String sql = "UPDATE " + table + " SET " + col + " = '" + val + "'";
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized boolean setTimestamp(String col, Timestamp val, String table, long ID) {
        return this.setTimestamp(col, val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setTimestamp(String col, Timestamp val, String table, String[] whereConditions) {
        String sql = "UPDATE " + table + " SET " + col + " = '" + val + "'";
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized boolean setInt(String col, int val, String table, long ID) {
        return this.setInt(col, (long)val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setInt(String col, long val, String table, String[] whereConditions) {
        String sql = "UPDATE " + table + " SET " + col + " = " + String.valueOf(val);
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized boolean setDouble(String col, double val, String table, long ID) {
        return this.setDouble(col, val, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean setDouble(String col, double val, String table, String[] whereConditions) {
        String sql = "UPDATE " + table + " SET " + col + " = " + String.valueOf(val);
        sql = sql + this.getWhereClause(whereConditions);
        return this.execute(sql);
    }

    protected synchronized ResultSet getResultSetFor(String table, long ID) {
        return this.getResultSetFor(table, new String[]{"ID = " + ID});
    }

    protected synchronized ResultSet getResultSetFor(String table, String[] whereConditions) {
        return this.getResultSetFor(table, null, whereConditions, null);
    }

    private synchronized ResultSet getResultSetFor(String table, String[] cols, String[] whereConditions, String orderBy) {
        return this.getResultSetFor(table, cols, whereConditions, orderBy, true);
    }

    private synchronized ResultSet getResultSetFor(String table, String[] cols, String[] whereConditions, String orderBy, boolean checkFirstElement) {
        StringBuilder colString = new StringBuilder();
        if (cols != null) {
            for (int i = 0; i < cols.length; ++i) {
                if (i != 0) {
                    colString.append(", ");
                }
                colString.append(cols[i]);
            }
        } else {
            colString.append("*");
        }
        String sql = "SELECT " + colString + " FROM " + table;
        if (whereConditions != null) {
            String whereString = " WHERE ";
            for (int i = 0; i < whereConditions.length; ++i) {
                if (i > 0) {
                    whereString = whereString + "AND ";
                }
                whereString = whereString + whereConditions[i] + " ";
            }
            sql = sql + whereString;
        }
        if (orderBy != null) {
            sql = sql + " ORDER BY " + orderBy;
        }
        ResultSet returnVal = null;
        try {
            returnVal = this.dc.executeQuery(sql);
            if (checkFirstElement && !returnVal.next()) {
                this.dc.release(returnVal);
                returnVal = null;
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized int getInt(String col, String table, long ID) {
        return this.getInt(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized int getInt(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        int returnVal = -1;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            if (rs.next()) {
                returnVal = rs.getInt(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized long getLong(String col, String table, long ID) {
        return this.getLong(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized long getLong(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        long returnVal = -1L;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            if (rs.next()) {
                returnVal = rs.getLong(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized Object getObject(String col, String table, long ID) {
        return this.getObject(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized Object getObject(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        Object returnVal = null;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            if (rs.next()) {
                returnVal = rs.getObject(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized String getString(String col, String table, long ID) {
        return this.getString(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized String getString(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        String returnVal = null;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            while (rs.next()) {
                returnVal = rs.getString(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized double getDouble(String col, String table, long ID) {
        return this.getDouble(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized double getDouble(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        double returnVal = 0.0;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            if (rs.next()) {
                returnVal = rs.getDouble(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized Date getDate(String col, String table, long ID) {
        return this.getDate(col, table, new String[]{"ID = " + ID});
    }

    private String getWhereClause(String[] whereConditions) {
        if (whereConditions == null) {
            return "";
        }
        StringBuilder whereString = new StringBuilder(" WHERE ");
        for (int i = 0; i < whereConditions.length; ++i) {
            if (i > 0) {
                whereString.append("AND ");
            }
            whereString.append(whereConditions[i]).append(" ");
        }
        return whereString.toString();
    }

    protected synchronized Date getDate(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        java.sql.Date returnVal = null;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            if (rs.next()) {
                returnVal = rs.getDate(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized Timestamp getTimestamp(String col, String table, long ID) {
        return this.getTimestamp(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized Timestamp getTimestamp(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        Timestamp returnVal = null;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            if (rs.next()) {
                returnVal = rs.getTimestamp(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized boolean getBool(String col, String table, long ID) {
        return this.getBool(col, table, new String[]{"ID = " + ID});
    }

    protected synchronized boolean getBool(String col, String table, String[] whereConditions) {
        String sql = "SELECT " + col + " FROM " + table;
        boolean returnVal = false;
        sql = sql + this.getWhereClause(whereConditions);
        try {
            ResultSet rs = this.dc.executeQuery(sql);
            while (rs.next()) {
                returnVal = rs.getBoolean(col);
            }
            this.dc.release(rs);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return returnVal;
    }

    protected synchronized ResultSet getAll(String table, boolean checkSystemState) throws SQLException {
        return this.getAll(table, null, checkSystemState);
    }

    protected synchronized ResultSet getAll(String table, String orderBy, boolean checkSystemState) throws SQLException {
        String sql = "SELECT * FROM " + table;
        if (checkSystemState) {
            sql = sql + " WHERE system_state = 'ACTIVE' ";
        }
        if (orderBy != null) {
            sql = sql + "ORDER BY " + orderBy;
        }
        return this.dc.executeQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean isNull(String table, String col, long ID) {
        String sql = "SELECT " + col + " FROM " + table + " WHERE ID = " + ID + " AND " + col + " IS NULL";
        ResultSet rs = null;
        try {
            rs = this.dc.executeQuery(sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            this.handleSQLError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    this.dc.release(rs);
                }
                catch (Exception ex) {
                    OrderMate.LOG.info("Exception releasing resultSet", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(String query, Object[] params) {
        boolean result = false;
        Object object = AbstractDatabaseService.getMutex();
        synchronized (object) {
            try {
                this.dc.execute(query, params);
                result = true;
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return result;
        }
    }

    private boolean execute(String sql) {
        return this.execute(sql, new Object[0]);
    }
}

