/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.IOException;
import ordermate.OrderMate;
import ordermate.database.misc.application.Application;

public abstract class AbstractUpdateConfigExecutable
extends Executable<String> {
    private Application[] terminalTypes;
    private String startsWith;
    private String replaceWith;
    private String terminatingStr;
    private final String DEFAULTTERM_STR = "\n";

    public AbstractUpdateConfigExecutable(Application[] theTerminalTypes, String replaceStartsWith, String withThis) {
        this.terminalTypes = theTerminalTypes;
        this.startsWith = replaceStartsWith;
        this.replaceWith = withThis;
        this.terminatingStr = "\n";
    }

    public AbstractUpdateConfigExecutable(Application[] theTerminalTypes, String replaceStartsWith, String withThis, String endStr) {
        this.terminalTypes = theTerminalTypes;
        this.startsWith = replaceStartsWith;
        this.replaceWith = withThis;
        this.terminatingStr = endStr;
    }

    @Override
    public String execute() {
        StringBuilder SB = new StringBuilder();
        for (Application nextType : this.terminalTypes) {
            SB.append((Object)nextType).append(" modified? ");
            SB.append(this.updateConfig(this.getAppFileConfigFileName(nextType)));
            SB.append("\r\n");
        }
        return SB.toString();
    }

    private boolean updateConfig(String theConfigFile) {
        String dir = this.getPathToFiles();
        if (dir == null || dir.isEmpty()) {
            OrderMate.LOG.error("Invalid path!");
            return false;
        }
        String configFile = dir + theConfigFile;
        OrderMate.LOG.info("Looking for config file :" + configFile);
        File file = new File(configFile);
        OrderMate.LOG.info("Found file? " + file.exists());
        try {
            String data = StringUtils.readInTextFile(file);
            if (data != null) {
                int index = data.indexOf(this.startsWith);
                OrderMate.LOG.info("Index found as:" + index);
                if (index >= 0) {
                    String toReplace = data.substring(index, data.indexOf(this.terminatingStr, index));
                    OrderMate.LOG.info("Replacing:" + toReplace + " with " + this.replaceWith + " in config:" + configFile);
                    String newData = data.replace(toReplace, this.replaceWith);
                    StringUtils.writeTextToFile(file, newData);
                    return true;
                }
                OrderMate.LOG.warn("Cannot find line starting with " + this.startsWith + " in config file " + configFile);
            } else {
                OrderMate.LOG.error("Cannot write to a config file that doesn't exist:" + configFile);
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Couldn't read in the given config file!" + configFile, (Throwable)ex);
        }
        return false;
    }

    protected abstract String getPathToFiles();

    protected abstract String getAppFileConfigFileName(Application var1);
}

