/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.database.DatabaseMaintenanceService;
import au.com.ordermate.guicore.task.TaskInterrupter;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.ServerConnectionManagerI;
import ordermate.database.DataService;
import ordermate.database.DatabaseService;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ServermateEventLog;
import ordermate.database.users.User;

public final class Data {
    public static DatabaseMaintenanceService dbMaintenance;
    public static DataService database;
    private static ServerConnectionManagerI serverConnection;
    private static ExceptionHandleMethod exceptionHandleMethod;
    private static PrintWriter writer;

    private Data() {
    }

    public static String getAbout() {
        try {
            return database.getAbout();
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    public static void repairAndOptimise(TaskInterrupter interrupter) {
        try {
            dbMaintenance.repairAndOptimise(interrupter);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public static void optimize() {
        try {
            dbMaintenance.optimizeDatabase();
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public static void repair(TaskInterrupter interrupter) {
        try {
            dbMaintenance.repair(interrupter);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public static boolean checkDatabase(TaskInterrupter interrupter) {
        try {
            return dbMaintenance.checkDatabase(interrupter);
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return false;
        }
    }

    public static void repairAndOptimise(User user, Terminal terminal, TaskInterrupter interrupter) {
        Data.repairAndOptimise(interrupter);
        ServermateEventLog.logDatabaseOptimise(user, terminal);
    }

    public static void handleException(RemoteException e) {
        if (exceptionHandleMethod.equals(ExceptionHandleMethod.LOG)) {
            OrderMate.LOG.error("RMI Error ", (Throwable)e);
        } else if (exceptionHandleMethod.equals(ExceptionHandleMethod.THROW)) {
            throw new RuntimeException(e);
        }
        if (serverConnection != null) {
            serverConnection.waitUntilConnected();
        }
    }

    private static void setupWriter() {
        try {
            FileOutputStream fos = new FileOutputStream("RMIError.log", true);
            writer = new PrintWriter(fos);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Error starting up rmi error log", (Throwable)e);
        }
    }

    public static synchronized void setup(DatabaseService ds) {
        Data.setup(ds, null);
    }

    public static synchronized void setDBMaintenanceService(DatabaseMaintenanceService service) {
        dbMaintenance = service;
    }

    public static synchronized void setup(DataService ds, ServerConnectionManagerI newServerConnection) {
        database = ds;
        serverConnection = newServerConnection;
    }

    public static void setExceptionHandleMethod(ExceptionHandleMethod method) {
        exceptionHandleMethod = method;
    }

    static {
        exceptionHandleMethod = ExceptionHandleMethod.LOG;
        writer = null;
    }

    public static class ExceptionHandleMethod {
        public static final ExceptionHandleMethod LOG = new ExceptionHandleMethod();
        public static final ExceptionHandleMethod THROW = new ExceptionHandleMethod();

        private ExceptionHandleMethod() {
        }
    }
}

