/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import ordermate.OrderMate;
import ordermate.database.AbstractDatabaseService;
import ordermate.database.DBConnectionInterface;
import ordermate.database.Data;
import ordermate.database.DataService;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.finance.CashDrawerTakingsSummaryCreator;
import ordermate.database.finance.RestaurantTakingsSummaryCreator;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.SalesItemPriceAdjustmentLink;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesOption;
import ordermate.database.stock.CachedStockTakeEntry;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockAdjustment;
import ordermate.database.stock.usage.StockTransfer;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.users.User;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class DatabaseService
extends AbstractDatabaseService
implements DataService {
    private final String taxFactor = "" + SystemProperty.getInstance().getBaseTaxFactor();

    public DatabaseService(DBConnectionInterface newDc) throws RemoteException {
        super(newDc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCompleteStockLinkage(long areaID, long itemID, boolean checkSOH, double itemCurrentCost) {
        long existingRow;
        if (checkSOH && (existingRow = (long)this.getInt("ID", "stock_on_hand", new String[]{"FK_stock_item = " + itemID, "FK_stock_area = " + areaID})) == -1L) {
            this.insert("stock_on_hand", new String[]{"FK_stock_item", "FK_stock_area", "Quantity", "AverageCost"}, new String[]{String.valueOf(itemID), String.valueOf(areaID), "0", String.valueOf(itemCurrentCost)});
        }
        existingRow = -1L;
        long stockTakeID = this.getInt("ID", "stock_take", new String[]{"Live = 1", SQL.isActive("stock_take")});
        if (stockTakeID == -1L) {
            return;
        }
        ResultSet rs = null;
        try {
            Object[] params = new Object[]{areaID, itemID};
            rs = this.dc.executeQuery(this.getGetExistingStockTakeEntryRowQuery().toString(), params);
            if (rs.next()) {
                existingRow = rs.getInt("stock_take_entry.ID");
            }
            try {
                if (rs != null) {
                    this.dc.release(rs);
                }
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Could not release result set", (Throwable)ex);
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        finally {
            try {
                if (rs != null) {
                    this.dc.release(rs);
                }
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Could not release result set", (Throwable)ex);
            }
        }
        if (existingRow != -1L) return;
        this.insert("stock_take_entry", new String[]{"FK_stock_item", "FK_stock_area", "FK_stock_take"}, new String[]{String.valueOf(itemID), String.valueOf(areaID), String.valueOf(stockTakeID)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveStockEntriesForNewStockArea(long areaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                ResultSet allStockItems = this.getAll("stock_item", true);
                while (allStockItems.next()) {
                    long itemID = allStockItems.getInt("ID");
                    double currentCost = allStockItems.getDouble("CurrentCost");
                    this.addCompleteStockLinkage(areaID, itemID, true, currentCost);
                }
                this.dc.release(allStockItems);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveStockEntriesForNewStockItem(long itemID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                ResultSet allStockAreas = this.getAll("stock_area", true);
                while (allStockAreas.next()) {
                    long areaID = allStockAreas.getInt("ID");
                    this.addCompleteStockLinkage(areaID, itemID, false, 0.0);
                }
                this.dc.release(allStockAreas);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStockItemBarcode(long stockItemID, String barcode) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.insert("stock_barcodes", "barcode, FK_stock_item", "'" + barcode + "', " + stockItemID);
        }
    }

    @Override
    public void adjustStockOnHand(long stockItemID, double qtyToAdd, double valueOfAddedQty, long stockAreaID, boolean adjustLiveStocktake) throws RemoteException {
        if (stockItemID == 0L) {
            throw new IllegalArgumentException("The stock item ID is null, the stock cannot be adjusted.");
        }
        if (stockAreaID == 0L) {
            throw new IllegalArgumentException("The stock area ID is null, the stock cannot be adjusted.");
        }
        Object[] params = new Object[]{stockItemID, stockAreaID};
        StockOnHand soh = PersistenceManager.getObject(StockOnHand.class, "SELECT * FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? ", params);
        if (soh == null) {
            OrderMate.LOG.info("adjustStockOnHand - returning since StockOnHand is not available for StockItem : " + stockItemID + " - StockArea : " + stockAreaID);
            return;
        }
        double qtyPerUnit = soh.getStockItem().getPurchaseQty().getRawValue();
        double existingQty = soh.getQuantity();
        double existingCost = soh.getTotalCostValueOfStockOnHand().doubleValue();
        double totalQty = existingQty + qtyToAdd;
        double totalCost = existingCost + valueOfAddedQty;
        if (MathsUtils.approxEquals(0.0, totalQty)) {
            soh.setOnHandCostPerItem(soh.getStockItem().getCurrentReplacementCost());
        } else {
            double newAverageCost = qtyPerUnit * totalCost / totalQty;
            soh.setOnHandCostPerItem(new Price(newAverageCost, 0.0));
        }
        soh.saveChild();
        this.adjustStockOnHand(stockItemID, qtyToAdd, stockAreaID, adjustLiveStocktake);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustStockOnHand(long stockItemID, double qtyToAdd, long stockAreaID, boolean adjustLiveStocktake) {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                long stockOnHandID = 0L;
                Object[] params = new Object[]{stockItemID, stockAreaID};
                String query = this.getGetStockOnHandIDForStockItemPS().toString();
                ResultSet rs = this.dc.executeQuery(query, params);
                try {
                    if (rs.next()) {
                        stockOnHandID = rs.getInt("ID");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
                if (stockOnHandID == 0L) {
                    params = new Object[]{stockItemID, new Double(qtyToAdd), stockAreaID};
                    this.execute(this.getAddStockOnHandQuery().toString(), params);
                } else {
                    String query2 = this.getUpdateStockOnHandQuery().toString();
                    Object[] params2 = new Object[]{new Double(qtyToAdd), stockOnHandID};
                    this.execute(query2, params2);
                }
                if (adjustLiveStocktake) {
                    params = new Object[]{new Double(qtyToAdd), new Double(qtyToAdd), stockItemID, stockAreaID};
                    this.execute(this.getAdjustLiveStockTakeActualQuantitiesQuery().toString(), params);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long clockUserOff(long userID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            long openSheetID;
            block16: {
                ResultSet rs = null;
                openSheetID = 0L;
                try {
                    Object[] params = new Object[]{userID};
                    rs = this.dc.executeQuery(this.getGetOpenSheetPS().toString(), params);
                    while (rs.next()) {
                        openSheetID = rs.getInt("ID");
                    }
                    if (openSheetID != 0L) {
                        params = new Object[]{openSheetID};
                        this.execute(this.getClockOffQuery().toString(), params);
                    }
                    if (rs == null) return openSheetID;
                }
                catch (SQLException e) {
                    this.handleSQLError(e);
                    break block16;
                }
                try {
                    this.dc.release(rs);
                }
                catch (SQLException e) {
                    OrderMate.LOG.error("Error releasing result set", (Throwable)e);
                }
                break block16;
                finally {
                    if (rs != null) {
                        try {
                            this.dc.release(rs);
                        }
                        catch (SQLException e) {
                            OrderMate.LOG.error("Error releasing result set", (Throwable)e);
                        }
                    }
                }
            }
            return openSheetID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockUserOn(long userID, long deptID, double payrate) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Object[] params = new Object[]{userID, deptID, payrate};
            this.execute(this.getClockUserOnQuery().toString(), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserClockedOn(long userID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            boolean clockedOn = false;
            try {
                Object[] params = new Object[]{userID};
                ResultSet rs = this.dc.executeQuery(this.getGetOpenSheetPS().toString(), params);
                while (rs.next()) {
                    clockedOn = true;
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return clockedOn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneComponentStockUsage(long oldComponentID, long newComponentID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                Object[] params = new Object[]{oldComponentID};
                ResultSet rs = this.dc.executeQuery(this.getGetComponentStockUsageQuery().toString(), params);
                try {
                    while (rs.next()) {
                        String reason = rs.getString("Reason");
                        if (reason != null) {
                            reason = this.singleQuotes(reason);
                        }
                        this.insert("stock_usage", new String[]{"system_state", "Quantity", "FK_stock_item", "FK_sales_component", "FK_config_user", "Reason", "usage_state", "FK_stock_area_transfer_to", "UsageDate", "FK_stock_area", "CreationDate", "HistoricalCost"}, new String[]{this.singleQuotes("CLONED"), rs.getString("Quantity"), rs.getString("FK_stock_item"), String.valueOf(newComponentID), rs.getString("FK_config_user"), reason, this.singleQuotes(rs.getString("usage_state")), rs.getString("FK_stock_area_transfer_to"), this.singleQuotes(rs.getTimestamp("UsageDate").toString()), rs.getString("FK_stock_area"), this.singleQuotes(rs.getTimestamp("CreationDate").toString()), rs.getString("HistoricalCost")});
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e, this.getGetComponentStockUsageQuery());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createStockInvoiceEntry(long stockItemID, double numReceived, double bonusReceived, double pricePaid, long invoiceID, String invoiceType, boolean taxIncluded, long stockAreaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double itemQty = this.getDouble("Quantity", "stock_item", stockItemID);
            Object[] params = new Object[]{stockItemID, new Double(numReceived), new Double(pricePaid), new Double(bonusReceived), taxIncluded ? 1L : 0L, invoiceID};
            try {
                long invoiceEntryID = this.dc.executeInsert(this.getAddInvoiceEntryQuery().toString(), params);
                double qtyToAdd = (numReceived + bonusReceived) * itemQty;
                if (!invoiceType.equals("Purchase Order")) {
                    this.adjustStockOnHand(stockItemID, qtyToAdd, pricePaid, stockAreaID, false);
                }
                return invoiceEntryID;
            }
            catch (SQLException ex) {
                this.handleSQLError(ex);
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockTake createStockTake() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            long newID = this.insert("stock_take", "EndDate", "'" + new Timestamp(System.currentTimeMillis()) + "'");
            try {
                ResultSet rs = this.dc.executeQuery(this.getCreateStockTake_GetEntryDataQuery().toString());
                while (rs.next()) {
                    long itemID = rs.getInt("stock_item.ID");
                    double cost = rs.getDouble("stock_on_hand.AverageCost");
                    double qty = rs.getDouble("stock_item.Quantity");
                    long areaID = rs.getInt("stock_area.ID");
                    this.insert("stock_take_entry", "FK_stock_item, FK_stock_area, FK_stock_take, CostPerAtomicUnit", itemID + ", " + areaID + ", " + newID + ", " + cost / qty);
                }
                this.dc.release(rs);
                return PersistenceManager.getByID(newID, StockTake.class);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
                newID = 0L;
                return null;
            }
        }
    }

    @Override
    public String getAbout() throws RemoteException {
        return "ServerMate <B>Version " + OrderMate.VERSION + "</B>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insert(String table, String column, String value) {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ObjectQuerySQLAdapter sql = new ObjectQuerySQLAdapter("INSERT INTO " + table + " (" + column + ") VALUES (" + value + " )");
            long ID = -1L;
            try {
                return this.dc.executeInsert(((ObjectQuery)sql).toString());
            }
            catch (SQLException e) {
                this.handleSQLError(e, sql);
                return ID;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insert(String table, String[] columns, String[] values) {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StringBuffer colString = new StringBuffer("");
            for (int i = 0; i < columns.length; ++i) {
                if (i != 0) {
                    colString.append(", ");
                }
                colString.append(columns[i]);
            }
            StringBuffer valuesString = new StringBuffer("");
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    valuesString.append(", ");
                }
                valuesString.append(values[i]);
            }
            ObjectQuerySQLAdapter sql = new ObjectQuerySQLAdapter("INSERT INTO " + table + " (" + colString.toString() + ") VALUES (" + valuesString.toString() + " )");
            long ID = -1L;
            try {
                ID = this.dc.executeInsert(((ObjectQuery)sql).toString());
                this.assertNot(ID, -1L, sql);
            }
            catch (SQLException e) {
                this.handleSQLError(e, sql);
            }
            return ID;
        }
    }

    @Override
    public void logCommandResponse(String destination, String timestamp, int commandID) throws RemoteException {
        Object[] params = new Object[]{destination, timestamp, commandID};
        this.execute(this.getLogCommandResponsePS().toString(), params);
    }

    @Override
    public void logSmsSend(String timestamp, String destination, String text, User user) throws RemoteException {
        Long userID = null;
        if (user != null) {
            userID = user.getID();
        }
        Object[] params = new Object[]{timestamp, destination, text, userID};
        this.execute(this.getLogSmsSendQuery().toString(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAdjustmentFromDb(SalesPriceAdjustment adjustment) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            String deleteLink = "DELETE FROM sales_item_price_adjustment_link WHERE FK_sales_price_adjustment = " + adjustment.getID();
            try {
                this.dc.execute(deleteLink);
                adjustment.deleteChild();
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String searchStreetDirectory(String streetName, String streetType, String suburb) throws RemoteException {
        String page = "";
        String grid = "";
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            String string;
            Object[] params = new Object[]{streetName, streetType, suburb};
            ResultSet rs = this.dc.executeQuery(this.getSearchStreetDirectoryQuery().toString(), params);
            try {
                if (rs.next()) {
                    page = rs.getString("page");
                    grid = rs.getString("grid_position");
                }
                string = page + " " + grid;
            }
            catch (Throwable throwable) {
                try {
                    this.dc.release(rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    this.handleSQLError(e);
                    return null;
                }
            }
            this.dc.release(rs);
            return string;
        }
    }

    private String singleQuotes(String str) {
        return "'" + str + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferStock(long stockItemID, double qty, long userID, String reason, long oldStockAreaID, long newStockAreaID, Date usageDate, boolean adjustLiveStocktake, double totalCost) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            long usageID = this.useStock(stockItemID, qty, userID, 0L, reason, "TRANSFER", oldStockAreaID, usageDate, adjustLiveStocktake, totalCost);
            this.setStockUsageAreaTransferredTo(usageID, newStockAreaID);
            this.adjustStockOnHand(stockItemID, qty, totalCost, newStockAreaID, adjustLiveStocktake);
            return usageID;
        }
    }

    @Override
    public long useStock(long stockItemID, double qty, long userID, long componentID, String reason, String usageState, long stockAreaID, Date usageDate, boolean adjustLiveStocktake, double totalCost) throws RemoteException {
        Long userIDVal = userID > 0L ? Long.valueOf(userID) : null;
        Long compIDVal = componentID > 0L ? Long.valueOf(componentID) : null;
        long createdID = 0L;
        Object[] params = new Object[]{stockItemID, new Double(qty), userIDVal, compIDVal, reason, usageState, stockAreaID, new Timestamp(usageDate.getTime()), new Timestamp(System.currentTimeMillis()), new Double(totalCost)};
        try {
            createdID = this.dc.executeInsert(this.getInsertStockUsageQuery().toString(), params);
            this.adjustStockOnHand(stockItemID, -qty, -totalCost, stockAreaID, adjustLiveStocktake);
            return createdID;
        }
        catch (SQLException ex) {
            this.handleSQLError(ex);
            return 0L;
        }
    }

    private ObjectQuery getUpdateStockOnHandQuery() {
        return new ObjectQuerySQLAdapter("UPDATE stock_on_hand SET Quantity = Quantity + ? WHERE ID = ? ");
    }

    private ObjectQuery getSearchStreetDirectoryQuery() {
        return new ObjectQuerySQLAdapter("SELECT page, grid_position FROM  street_directory_ref WHERE street_name = ? AND street_type = ? AND suburb = ?");
    }

    ObjectQuery getLogSmsSendQuery() {
        return new ObjectQuerySQLAdapter("INSERT INTO system_sms_log (timestamp, destination, text, FK_config_user) VALUES (?, ?, ?, ?)");
    }

    ObjectQuery getLogCommandResponsePS() {
        return new ObjectQuerySQLAdapter("INSERT INTO system_command_log (destination, timestamp, FK_config_command) VALUES (?, ?, ?) ");
    }

    ObjectQuery getInsertStockUsageQuery() {
        return new ObjectQuerySQLAdapter("INSERT INTO stock_usage (FK_stock_item, Quantity, FK_config_user, FK_sales_component, Reason, usage_state, FK_stock_area, UsageDate, CreationDate, HistoricalCost) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    private ObjectQuery getGetStockOnHandIDForStockItemPS() {
        return new ObjectQuerySQLAdapter("SELECT ID, Quantity, AverageCost FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? AND system_state = 'ACTIVE'");
    }

    private ObjectQuery getGetOpenSheetPS() {
        return new ObjectQuerySQLAdapter("SELECT finance_timesheet.ID FROM finance_timesheet, config_user WHERE finance_timesheet.Time_OUT IS NULL AND finance_timesheet.FK_config_user = config_user.ID AND finance_timesheet.FK_config_user = ?");
    }

    private ObjectQuery getGetExistingStockTakeEntryRowQuery() {
        return new ObjectQuerySQLAdapter("SELECT stock_take_entry.ID FROM stock_take_entry, stock_take WHERE " + SQL.join("stock_take_entry", "stock_take") + "AND stock_take.Live = 1 AND " + SQL.isActive("stock_take") + "AND FK_stock_area = ? AND FK_stock_item = ? ");
    }

    private ObjectQuerySQLAdapter getGetComponentStockUsageQuery() {
        return new ObjectQuerySQLAdapter("SELECT stock_usage.* FROM stock_usage WHERE stock_usage.FK_sales_component = ? AND stock_usage.usage_state = 'NORMAL' ");
    }

    private ObjectQuery getCreateStockTake_GetEntryDataQuery() {
        return new ObjectQuerySQLAdapter("SELECT stock_item.Quantity, stock_on_hand.AverageCost, stock_item.ID, stock_area.ID FROM stock_item, stock_on_hand, stock_area WHERE stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_area.ID AND stock_on_hand.system_state = 'ACTIVE' AND stock_item.system_state = 'ACTIVE' AND stock_area.system_state = 'ACTIVE' ");
    }

    private ObjectQuery getClockUserOnQuery() {
        return new ObjectQuerySQLAdapter("INSERT INTO finance_timesheet (Time_IN, FK_config_user, FK_config_department, pay_rate, FK_finance_trading_day) SELECT NOW(), ?, ?, ?, FK_finance_trading_day FROM system_current_info");
    }

    private ObjectQuery getClockOffQuery() {
        return new ObjectQuerySQLAdapter("UPDATE finance_timesheet SET Time_OUT  = Now() WHERE ID = ?");
    }

    private ObjectQuery getAdjustLiveStockTakeActualQuantitiesQuery() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry, stock_take SET stock_take_entry.ActualQty = stock_take_entry.ActualQty + ?, stock_take_entry.unit_qty = stock_take_entry.unit_qty + ? WHERE stock_take_entry.ActualQty IS NOT NULL AND stock_take_entry.FK_stock_take = stock_take.ID AND stock_take.Live AND stock_take_entry.FK_stock_item = ? AND stock_take_entry.FK_stock_area = ? ");
    }

    private ObjectQuery getAddStockOnHandQuery() {
        return new ObjectQuerySQLAdapter("INSERT INTO stock_on_hand (FK_stock_item, Quantity, FK_stock_area) VALUES (?, ?, ?)");
    }

    private ObjectQuery getAddInvoiceEntryQuery() {
        return new ObjectQuerySQLAdapter("INSERT INTO stock_invoice_entry (FK_stock_item, NumReceived, PricePaid, BonusReceived, tax_included, FK_stock_invoice) VALUES (?, ?, ?, ?, ?, ?)");
    }

    @Override
    public void adjustAllInvoiceQuantitiesForItem(long stockItemID, double multiplier) throws RemoteException {
        Object[] params = new Object[]{new Double(multiplier), new Double(multiplier), stockItemID};
        this.execute(this.getAdjustAllInvoiceQuantitiesPS().toString(), params);
    }

    @Override
    @Deprecated
    public void adjustStockForChangedStockItemMeasureUnit(long stockItemID, String newMeasureName, String oldMeasureName) throws RemoteException {
        MeasureUnit oldMeasure = MeasureUnitHelper.getMeasureUnit(oldMeasureName);
        MeasureUnit newMeasure = MeasureUnitHelper.getMeasureUnit(newMeasureName);
        if (newMeasure.getValue() != oldMeasure.getValue()) {
            double ratio = newMeasure.getValue() / oldMeasure.getValue();
            Object[] params2 = new Object[]{new Double(ratio), stockItemID};
            Object[] params3 = new Object[]{new Double(ratio), new Double(ratio), stockItemID};
            this.execute(this.getUpdateStockValuesForUnitChange_SOH_PS().toString(), params2);
            this.execute(this.getUpdateStockValuesForUnitChange_Usage_PS().toString(), params2);
            this.execute(this.getUpdateStockValuesForUnitChange_StockTakes_PS().toString(), params3);
            this.execute(this.getUpdateStockValuesForUnitChange_UnitsLink_PS().toString(), params2);
            this.execute(this.getUpdateStockValuesForUnitChange_OptionsLink_PS().toString(), params2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelStockUsage(long stockUsageID, boolean adjustLiveStocktake) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            long stockItemID = this.getLong("FK_stock_item", "stock_usage", stockUsageID);
            long stockAreaID = this.getLong("FK_stock_area", "stock_usage", stockUsageID);
            double qty = this.getDouble("Quantity", "stock_usage", stockUsageID);
            String usageState = this.getString("usage_state", "stock_usage", stockUsageID);
            double cost = this.getDouble("HistoricalCost", "stock_usage", stockUsageID);
            Data.database.adjustStockOnHand(stockItemID, qty, cost, stockAreaID, adjustLiveStocktake);
            if (usageState.equals("TRANSFER")) {
                long stockAreaTransferToID = this.getLong("FK_stock_area_transfer_to", "stock_usage", stockUsageID);
                Data.database.adjustStockOnHand(stockItemID, -qty, -cost, stockAreaTransferToID, adjustLiveStocktake);
            }
            this.setString("system_state", "DELETED", "stock_usage", stockUsageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStockTakeEntryActualQty(long stockTakeEntryID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setToNull("ActualQty", "stock_take_entry", stockTakeEntryID);
        }
    }

    private StockAdjustment createStockAdjustment(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        try {
            long id = rs.getLong("ID");
            StockAdjustment adjustment = new StockAdjustment(id);
            return adjustment;
        }
        catch (SQLException e) {
            this.handleSQLError(e);
            return null;
        }
    }

    private StockTake createStockTake(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        try {
            long id = rs.getLong("ID");
            return PersistenceManager.getByID(id, StockTake.class);
        }
        catch (SQLException e) {
            this.handleSQLError(e);
            return null;
        }
    }

    private StockTransfer createStockTransfer(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        try {
            long id = rs.getLong("ID");
            StockTransfer usage = new StockTransfer(id);
            return usage;
        }
        catch (SQLException e) {
            this.handleSQLError(e);
            return null;
        }
    }

    private StockWastage createStockWastage(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        try {
            long id = rs.getLong("ID");
            StockWastage usage = new StockWastage(id);
            return usage;
        }
        catch (SQLException e) {
            this.handleSQLError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStockInvoiceEntry(long invoiceEntryID, String invoiceType) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setString("system_state", "DELETED", "stock_invoice_entry", invoiceEntryID);
            if (!invoiceType.equals("Purchase Order")) {
                StockInvoiceEntry entry = PersistenceManager.getByID(invoiceEntryID, StockInvoiceEntry.class);
                StockItem item = entry.getStockItem();
                StockArea area = entry.getInvoice().getStockArea();
                double qtyPerUnit = item.getPurchaseQty().getRawValue();
                Data.database.adjustStockOnHand(item.intID(), -entry.getTotalReceived() * qtyPerUnit, -entry.getPricePaid().doubleValue(), area.intID(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUnitBarcode(String s, long unit) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                Object[] params = new Object[]{s};
                ResultSet idRS = this.dc.executeQuery(this.getGetBarcodeIDPS().toString(), params);
                try {
                    while (idRS.next()) {
                        long deleteID = idRS.getLong("ID");
                        this.delete("inventory_item_unit_barcodes_link", new String[]{"FK_inventory_item_unit_barcodes = " + deleteID, "FK_inventory_item_unit = " + unit});
                    }
                }
                finally {
                    this.dc.release(idRS);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
                OrderMate.LOG.info("Cannot delete barcode " + s + " from unit " + unit, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InventoryItemUnit findInventoryItemUnit(String itemName, String itemSize, String itemPortion, long itemProfile) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            InventoryItemUnit returnItem = null;
            try {
                Object[] params = new Object[]{itemName, itemSize, itemPortion, itemProfile};
                ResultSet itemRS = this.dc.executeQuery(this.getFindInventoryItemUnitPS().toString(), params);
                try {
                    while (itemRS.next()) {
                        long id = itemRS.getLong("ID");
                        returnItem = InventoryItemUnit.getUnitByID(id);
                    }
                }
                finally {
                    this.dc.release(itemRS);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            this.assertNotNull(returnItem, this.getFindInventoryItemUnitPS());
            return returnItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getAreaStockOnHandForItem(long stockItemID, long stockAreaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double stockOnHand = 0.0;
            try {
                Object[] params = new Long[]{stockItemID, stockAreaID};
                ResultSet rs = this.dc.executeQuery(this.getGetAreaStockOnHandForItemPS().toString(), params);
                try {
                    if (rs.next()) {
                        stockOnHand = rs.getDouble("Quantity");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return stockOnHand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getBarcodePrefixes() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> barcodes = new ArrayList<String>();
            try {
                ResultSet rs = this.getAll("config_barcode_prefixes", false);
                while (rs.next()) {
                    String currentPrefix = rs.getString("prefix");
                    barcodes.add(currentPrefix);
                }
                if (barcodes.isEmpty()) {
                    OrderMate.LOG.info("No barcode prefixes found in system");
                }
                this.dc.release(rs);
                return barcodes;
            }
            catch (SQLException e) {
                OrderMate.LOG.error("Couldn't acquire list of barcode prefixes", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBarcodesForStockItem(long stockItemID) {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> retval = new ArrayList<String>();
            try {
                Object[] params = new Long[]{stockItemID};
                ResultSet rs = this.dc.executeQuery(this.getGetBarcodesForStockItemPS().toString(), params);
                try {
                    while (rs.next()) {
                        retval.add(rs.getString("barcode"));
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CashDrawerTakingsSummary getCashDrawerTakingsSummary(CashDrawer cashdrawer, Shift shift) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            CashDrawerTakingsSummaryCreator creator = new CashDrawerTakingsSummaryCreator(this);
            return creator.createSummary(cashdrawer, shift, this.dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getCashDrawerUser(long CashDrawerD, long terminalID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            String sql = "SELECT config_user.* FROM config_user, config_terminal_cashdrawer, config_cashdrawer WHERE config_terminal_cashdrawer.FK_config_cashdrawer = ? AND config_terminal_cashdrawer.FK_config_terminal = ? AND config_user.ID = config_terminal_cashdrawer.FK_config_user AND config_cashdrawer.ID = config_terminal_cashdrawer.FK_config_cashdrawer AND config_cashdrawer.system_state = 'ACTIVE'";
            User toReturn = PersistenceManager.getObject(User.class, sql, new Long[]{CashDrawerD, terminalID});
            return toReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Price getComponentAverageUsageCostIncTax(long componentID, long stockItemID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Price retval = null;
            try {
                Object[] params = new Long[]{componentID, stockItemID};
                ResultSet rs = this.dc.executeQuery(this.getGetComponentUsageCostPS().toString(), params);
                try {
                    if (rs.next()) {
                        retval = new Price(rs.getDouble("AvgCost"), 0.0);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getEmailPermissions(String commandName) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> permissions = new ArrayList<String>();
            try {
                Object[] params = new Object[]{commandName};
                ResultSet rs = this.dc.executeQuery(this.getGetEmailPermissionsPS().toString(), params);
                try {
                    while (rs.next()) {
                        permissions.add(rs.getString("email"));
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getInventoryItemUnitBarcode(long id) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> barcodes = new ArrayList<String>();
            try {
                Object[] params = new Long[]{id};
                ResultSet rs = this.dc.executeQuery(this.getGetInventoryItemUnitBarcodePS().toString(), params);
                try {
                    while (rs.next()) {
                        barcodes.add(rs.getString("barcode"));
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return barcodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getInvoiceStockArea(long invoiceID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getLong("FK_stock_area", "stock_invoice", invoiceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockTake getLastSavedStockTake() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StockTake retval = null;
            try {
                ResultSet rs = this.dc.executeQuery(this.getGetLastSavedStockTakePS().toString());
                if (rs.next()) {
                    retval = this.createStockTake(rs);
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockTake getLastStockTake() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StockTake retval = null;
            try {
                ResultSet rs = this.dc.executeQuery(this.getGetLastStockTakePS().toString());
                if (rs.next()) {
                    retval = this.createStockTake(rs);
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockTake getFirstStockTake() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StockTake retval = null;
            try {
                ResultSet rs = this.dc.executeQuery(this.getGetFirstStockTakePS().toString());
                if (rs.next()) {
                    retval = this.createStockTake(rs);
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockTake getLiveStockTake() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StockTake retval = null;
            try {
                ResultSet rs = this.dc.executeQuery(this.getGetLiveStockTakePS().toString());
                if (rs.next()) {
                    retval = this.createStockTake(rs);
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPhonePermissions(String commandName) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> permissions = new ArrayList<String>();
            try {
                Object[] params = new Object[]{commandName};
                ResultSet rs = this.dc.executeQuery(this.getGetPhonePermissionsPS().toString(), params);
                try {
                    while (rs.next()) {
                        permissions.add(rs.getString("phone"));
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestaurantTakingsSummary getRestaurantTakingsSummary(Shift shift) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return new RestaurantTakingsSummaryCreator(this, this.dc, shift).createSummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getSavedStockTakes() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            if (this.getGetSavedStockTakesPS() == null) {
                // empty if block
            }
            Vector<StockTake> retval = new Vector<StockTake>();
            try {
                ResultSet rs = this.dc.executeQuery(this.getGetSavedStockTakesPS().toString());
                while (rs.next()) {
                    StockTake st = this.createStockTake(rs);
                    retval.add(st);
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStockAdjustments(Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<StockAdjustment> retval = new ArrayList<StockAdjustment>();
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{"ADJUST", sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockUsagePS().toString(), params);
                try {
                    while (rs.next()) {
                        StockAdjustment usage = this.createStockAdjustment(rs);
                        retval.add(usage);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Price getStockAreaTotalAdjustmentValue(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Price retval = new Price(0.0, 0.0);
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockAreaTotalAdjustmentValuePS().toString(), params);
                try {
                    if (rs.next()) {
                        retval = new Price(rs.getDouble("Value"), 0.0);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Price getStockAreaTotalAdjustmentValueHistorical(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Price retval = new Price(0.0, 0.0);
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockAreaTotalAdjustmentValuePS().toString(), params);
                try {
                    if (rs.next()) {
                        retval = new Price(rs.getDouble("Historical"), 0.0);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockAreaTotalInvoiceValue(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double retval = 0.0;
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                ResultSet rs1 = this.dc.executeQuery(this.getGetStockAreaTotalInvoiceValuePS().toString(), params);
                try {
                    if (rs1.next()) {
                        retval = rs1.getDouble("Value");
                    }
                }
                finally {
                    this.dc.release(rs1);
                }
                ResultSet rs2 = this.dc.executeQuery(this.getGetStockAreaTotalInvoiceExtrasValuePS().toString(), params);
                try {
                    if (rs2.next()) {
                        retval += rs2.getDouble("Value");
                    }
                }
                finally {
                    this.dc.release(rs2);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockAreaTotalTransferValue(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double retval = 0.0;
            try {
                ResultSet rs2;
                ResultSet rs1;
                block17: {
                    Timestamp sqlFrom = new Timestamp(from.getTime());
                    Timestamp sqlTo = new Timestamp(to.getTime());
                    Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                    rs1 = null;
                    rs2 = null;
                    try {
                        rs1 = this.dc.executeQuery(this.getGetStockAreaTotalIncomingTransferValuePS().toString(), params);
                        rs2 = this.dc.executeQuery(this.getGetStockAreaTotalOutgoingTransferValuePS().toString(), params);
                        if (!rs1.next() || !rs2.next()) break block17;
                        retval = rs1.getDouble("Value") - rs2.getDouble("Value");
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs1 != null) {
                                this.dc.release(rs1);
                            }
                        }
                        finally {
                            if (rs2 != null) {
                                this.dc.release(rs2);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (rs1 != null) {
                        this.dc.release(rs1);
                    }
                }
                finally {
                    if (rs2 != null) {
                        this.dc.release(rs2);
                    }
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockAreaTotalTransferValueHistorical(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double retval = 0.0;
            try {
                ResultSet rs2;
                ResultSet rs1;
                block17: {
                    Timestamp sqlFrom = new Timestamp(from.getTime());
                    Timestamp sqlTo = new Timestamp(to.getTime());
                    Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                    rs1 = null;
                    rs2 = null;
                    try {
                        rs1 = this.dc.executeQuery(this.getGetStockAreaTotalIncomingTransferValuePS().toString(), params);
                        rs2 = this.dc.executeQuery(this.getGetStockAreaTotalOutgoingTransferValuePS().toString(), params);
                        if (!rs1.next() || !rs2.next()) break block17;
                        retval = rs1.getDouble("Historical") - rs2.getDouble("Historical");
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs1 != null) {
                                this.dc.release(rs1);
                            }
                        }
                        finally {
                            if (rs2 != null) {
                                this.dc.release(rs2);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (rs1 != null) {
                        this.dc.release(rs1);
                    }
                }
                finally {
                    if (rs2 != null) {
                        this.dc.release(rs2);
                    }
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockAreaTotalWastageValue(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double retval = 0.0;
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockAreaTotalWastageValuePS().toString(), params);
                try {
                    if (rs.next()) {
                        retval = rs.getDouble("Value");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockAreaTotalWastageValueHistorical(long stockAreaID, Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double retval = 0.0;
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{stockAreaID, sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockAreaTotalWastageValuePS().toString(), params);
                try {
                    if (rs.next()) {
                        retval = rs.getDouble("Historical");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StockTake getStockTake(long stockTakeID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                Object[] params = new Long[]{stockTakeID};
                ResultSet rs = this.dc.executeQuery(this.getGetStockTakePS().toString(), params);
                try {
                    if (rs.next()) {
                        StockTake stockTake = this.createStockTake(rs);
                        return stockTake;
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return null;
        }
    }

    @Override
    public Date getStockTakeCreationDate(long stockTakeID) throws RemoteException {
        return this.getDate("CreationDate", "stock_take", stockTakeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Price getStockTakeCurrentCostVarianceValue(long stockTakeID, long stockAreaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double variance = 0.0;
            ObjectQuery usedStatement = null;
            Object[] params = null;
            if (stockAreaID == 0L) {
                if (this.getGetStockTakeTotalCurrentCostVariancePS() == null) {
                    params = new Long[]{stockTakeID};
                }
                usedStatement = this.getGetStockTakeTotalCurrentCostVariancePS();
            } else {
                params = new Long[]{stockTakeID, stockAreaID};
                usedStatement = this.getGetStockTakeAreaCurrentCostVariancePS();
            }
            try {
                ResultSet rs = this.dc.executeQuery(usedStatement.toString(), params);
                try {
                    if (rs.next()) {
                        variance = rs.getDouble("VarianceVal");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return new Price(variance, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getStockTakeDate(long stockTakeID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Timestamp tstamp = this.getTimestamp("EndDate", "stock_take", stockTakeID);
            return new Date(tstamp.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStockTakeEntries(long stockTakeID, long stockAreaID, long stockGroupID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<Long> stockGroups = new ArrayList<Long>();
            ArrayList<CachedStockTakeEntry> entries = new ArrayList<CachedStockTakeEntry>();
            try {
                stockGroups.add(stockGroupID);
                for (int i = 0; i < stockGroups.size(); ++i) {
                    Long groupID = (Long)stockGroups.get(i);
                    Object[] params = new Long[]{groupID};
                    ResultSet rs = this.dc.executeQuery(this.getGetSubStockGroupsPS().toString(), params);
                    try {
                        while (rs.next()) {
                            stockGroups.add(rs.getLong("ID"));
                        }
                    }
                    finally {
                        this.dc.release(rs);
                    }
                    params = new Long[]{stockTakeID, stockAreaID, stockAreaID, groupID};
                    rs = this.dc.executeQuery(this.getGetStockTakeEntriesPS().toString(), params);
                    try {
                        while (rs.next()) {
                            String unit = rs.getString("DisplayMeasureUnit");
                            MeasureUnit measureUnit = MeasureUnitHelper.getMeasureUnit(unit);
                            double theo = rs.getDouble("TheoreticalQty");
                            Quantity theoretical = new Quantity((MeasureUnitI)measureUnit, theo);
                            double act = rs.getDouble("ActualQty");
                            Quantity actual = null;
                            if (!rs.wasNull()) {
                                actual = new Quantity((MeasureUnitI)measureUnit, act);
                            }
                            String name = rs.getString("Name");
                            long ID = rs.getLong("ID");
                            long itemID = rs.getLong("itemID");
                            List<String> barcodes = this.getBarcodesForStockItem(itemID);
                            CachedStockTakeEntry entry = new CachedStockTakeEntry(ID, name, theoretical, actual, itemID, barcodes);
                            entries.add(entry);
                        }
                        continue;
                    }
                    finally {
                        this.dc.release(rs);
                    }
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            if (stockGroups.size() > 1) {
                Collections.sort(entries);
            }
            return entries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getStockTakeEntryActualQty(long stockTakeEntryID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            if (this.isNull("stock_take_entry", "ActualQty", stockTakeEntryID)) {
                return null;
            }
            return new Double(this.getDouble("ActualQty", "stock_take_entry", stockTakeEntryID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockTakeEntryCostPerAtomicUnit(long stockTakeEntryID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getDouble("CostPerAtomicUnit", "stock_take_entry", stockTakeEntryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockTakeEntryExpectedQty(long stockTakeEntryID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getDouble("TheoreticalQty", "stock_take_entry", stockTakeEntryID);
        }
    }

    @Override
    public StockItem getStockTakeEntryItem(long stockTakeEntryID) throws RemoteException {
        long stockItemID = this.getLong("FK_stock_item", "stock_take_entry", stockTakeEntryID);
        return PersistenceManager.getByID(stockItemID, StockItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockTake getStockTakeForEntry(long stockTakeEntryID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            long stockTakeID = this.getLong("FK_stock_take", "stock_take_entry", stockTakeEntryID);
            ResultSet rs = this.getResultSetFor("stock_take", stockTakeID);
            StockTake retVal = this.createStockTake(rs);
            try {
                this.dc.release(rs);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getStockTakes() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Vector<StockTake> retval = new Vector<StockTake>();
            try {
                ResultSet all = this.getAll("stock_take", "EndDate DESC", true);
                while (all.next()) {
                    StockTake stockTake = this.createStockTake(all);
                    retval.add(stockTake);
                }
                this.dc.release(all);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStockTakesForDateRange(Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<StockTake> retval = new ArrayList<StockTake>();
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockTakesForDateRangePS().toString(), params);
                try {
                    while (rs.next()) {
                        StockTake stockTake = this.createStockTake(rs);
                        retval.add(stockTake);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Price getStockTakeVarianceValue(long stockTakeID, long stockAreaID, boolean live) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double variance = 0.0;
            ObjectQuery usedStatement = null;
            Object[] params = null;
            if (stockAreaID == 0L) {
                params = new Long[]{stockTakeID};
                usedStatement = live ? this.getGetStockTakeTotalVarianceLivePS() : this.getGetStockTakeTotalVarianceSavedPS();
            } else {
                params = new Long[]{stockTakeID, stockAreaID};
                usedStatement = live ? this.getGetStockTakeAreaVarianceLivePS() : this.getGetStockTakeAreaVarianceSavedPS();
            }
            try {
                ResultSet rs = this.dc.executeQuery(usedStatement.toString(), params);
                try {
                    if (rs.next()) {
                        variance = rs.getDouble("VarianceVal");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return new Price(variance, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStockTransfers(Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<StockTransfer> retval = new ArrayList<StockTransfer>();
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{"TRANSFER", sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockUsagePS().toString(), params);
                try {
                    while (rs.next()) {
                        StockTransfer usage = this.createStockTransfer(rs);
                        retval.add(usage);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    @Override
    public StockArea getStockUsageArea(long usageID) throws RemoteException {
        long stockAreaID = this.getLong("FK_stock_area", "stock_usage", usageID);
        return PersistenceManager.getByID(stockAreaID, StockArea.class);
    }

    @Override
    public StockArea getStockUsageAreaTransferredTo(long usageID) throws RemoteException {
        long stockAreaID = this.getLong("FK_stock_area_transfer_to", "stock_usage", usageID);
        return PersistenceManager.getByID(stockAreaID, StockArea.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getStockUsageCreationDate(long usageID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return new Date(this.getTimestamp("CreationDate", "stock_usage", usageID).getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getStockUsageDate(long usageID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return new Date(this.getTimestamp("UsageDate", "stock_usage", usageID).getTime());
        }
    }

    @Override
    public double getStockUsageHistoricalCost(long usageID) {
        return this.getDouble("HistoricalCost", "stock_usage", usageID);
    }

    @Override
    public StockItem getStockUsageItem(long usageID) throws RemoteException {
        long stockItemID = this.getLong("FK_stock_item", "stock_usage", usageID);
        return PersistenceManager.getByID(stockItemID, StockItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStockUsageQty(long usageID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getDouble("Quantity", "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStockUsageReason(long usageID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getString("Reason", "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStockUsageState(long usageID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getString("usage_state", "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getStockUsageUser(long usageID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            long userID = this.getLong("FK_config_user", "stock_usage", usageID);
            return PersistenceManager.getByID(userID, User.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StockWastage> getStockWastages(Date from, Date to) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<StockWastage> retval = new ArrayList<StockWastage>();
            try {
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                Object[] params = new Object[]{"WASTED", sqlFrom, sqlTo};
                ResultSet rs = this.dc.executeQuery(this.getGetStockUsagePS().toString(), params);
                try {
                    while (rs.next()) {
                        StockWastage usage = this.createStockWastage(rs);
                        retval.add(usage);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StockWastage getStockWastageByID(long longValue) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StockWastage retval = null;
            try {
                Object[] params = new Object[]{longValue, "WASTED"};
                ResultSet rs = this.dc.executeQuery(this.getGetStockWastageByID().toString(), params);
                try {
                    while (rs.next()) {
                        StockWastage usage;
                        retval = usage = this.createStockWastage(rs);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalSOHValueForArea(long stockAreaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double retval = 0.0;
            try {
                Object[] params = new Long[]{stockAreaID};
                ResultSet rs = this.dc.executeQuery(this.getGetTotalSOHValueForAreaPS().toString(), params);
                try {
                    if (rs.next()) {
                        retval = rs.getDouble("Value");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalStockOnHandForItem(long stockItemID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            double stockOnHand = 0.0;
            try {
                Object[] params = new Long[]{stockItemID};
                ResultSet rs = this.dc.executeQuery(this.getGetTotalStockOnHandForItemPS().toString(), params);
                try {
                    if (rs.next()) {
                        stockOnHand = rs.getDouble("TotalQty");
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return stockOnHand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVideoProMachineName(long cameraID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getString("videopro_host_name", "config_videopro_camera", cameraID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVideoProPort(long cameraID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            return this.getInt("port_used", "config_videopro_camera", cameraID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInventoryItemUnitStockOverSold(long itemUnitID, int quantityToSell) throws RemoteException {
        boolean retval = false;
        try {
            Object[] params = new Object[]{(long)quantityToSell, itemUnitID};
            ResultSet rs = this.dc.executeQuery(this.getIsInventoryItemUnitStockOverSoldPS().toString(), params);
            try {
                while (rs.next()) {
                    if (!rs.getBoolean("OverSold")) continue;
                    retval = true;
                    break;
                }
            }
            finally {
                this.dc.release(rs);
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PersistentObject> void deleteViaPersistence(Class<T> classToDelete, String selectQuery) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.dc.executeQuery(selectQuery);
            while (rs.next()) {
                PersistenceManager.getPersistenceDelegate().delete(rs.getLong(1), classToDelete);
            }
        }
        finally {
            this.dc.release(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nukeAccount(long accountID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                List<SalesPriceAdjustment> adjustments = PersistenceManager.getObjectList(SalesPriceAdjustment.class, Query.select(SalesPriceAdjustment.class).equalsParam(SalesPriceAdjustment.Properties.ACCOUNT).toString(), accountID);
                for (SalesPriceAdjustment spa : adjustments) {
                    spa.deleteChild();
                }
                Account toBeDeleted = PersistenceManager.getByID(accountID, Account.class);
                if (toBeDeleted != null) {
                    PersistenceManager.getPersistenceDelegate().delete(accountID, toBeDeleted.getClass());
                }
                this.deleteViaPersistence(SalesItemQuantity.class, "SELECT sales_item_quantity.ID AS qtyID FROM sales_item_quantity INNER JOIN sales_item ON fk_sales_item = sales_item.ID WHERE sales_item.FK_sales_account = " + accountID);
                this.deleteViaPersistence(SalesOption.class, "SELECT sales_option.ID AS Option_ID FROM sales_option INNER JOIN sales_component ON sales_option.fk_sales_component = sales_component.ID INNER JOIN sales_item on fk_sales_item = sales_item.ID WHERE fk_sales_account = " + accountID);
                this.deleteViaPersistence(SalesAdd.class, "SELECT sales_add.ID AS Option_ID FROM sales_add INNER JOIN sales_component ON sales_add.fk_sales_component = sales_component.ID INNER JOIN sales_item on fk_sales_item = sales_item.ID WHERE fk_sales_account = " + accountID);
                this.deleteViaPersistence(AbstractSalesRemove.class, "SELECT sales_remove.ID AS Option_ID FROM sales_remove INNER JOIN sales_component ON sales_remove.fk_sales_component = sales_component.ID INNER JOIN sales_item on fk_sales_item = sales_item.ID WHERE fk_sales_account = " + accountID);
                this.deleteViaPersistence(SalesComponent.class, "SELECT sales_component.ID AS Comp_ID FROM sales_component INNER JOIN sales_item ON FK_sales_item = sales_item.ID WHERE FK_sales_account = " + accountID);
                this.deleteViaPersistence(SalesComponentTax.class, "SELECT sales_component_tax.ID as tax_id FROM sales_component_tax INNER JOIN sales_component ON FK_sales_component = sales_component.ID INNER JOIN sales_item ON sales_component.fk_sales_item = sales_item.id WHERE sales_item.FK_sales_account = " + accountID);
                this.deleteViaPersistence(FinanceTransaction.class, "SELECT finance_transaction.ID FROM finance_transaction WHERE fk_payoff_account = " + accountID);
                this.dc.execute("DELETE finance_transaction_item.* FROM finance_transaction_item INNER JOIN sales_item ON fk_sales_item = sales_item.ID WHERE fk_sales_account =" + accountID);
                this.dc.execute("DELETE FROM system_docket WHERE fk_sales_account = " + accountID);
                ResultSet rs = null;
                try {
                    rs = this.dc.executeQuery("SELECT sales_item.ID AS Item_ID FROM sales_item WHERE FK_sales_account = " + accountID);
                    while (rs.next()) {
                        long itemID = rs.getLong("Item_ID");
                        adjustments = PersistenceManager.getObjectList(SalesPriceAdjustment.class, Query.select(SalesPriceAdjustment.class).linkUsing(SalesItemPriceAdjustmentLink.Properties.SALES_PRICE_ADJUSTMENT).equalsParam(SalesItemPriceAdjustmentLink.Properties.SALES_LINE_ITEM).toString(), itemID);
                        for (SalesPriceAdjustment spa : adjustments) {
                            spa.deleteChild();
                        }
                        PersistenceManager.getPersistenceDelegate().delete(itemID, SalesLineItem.class);
                    }
                }
                catch (Throwable throwable) {
                    this.dc.release(rs);
                    throw throwable;
                }
                this.dc.release(rs);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTradingDay(long tradingDayID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                PersistenceManager.getPersistenceDelegate().delete(tradingDayID, TradingDay.class);
                this.deleteViaPersistence(Shift.class, "SELECT finance_shift.ID AS shift_id FROM finance_shift INNER JOIN finance_trading_day ON fk_finance_trading_day = finance_trading_day.ID WHERE finance_shift.fk_finance_trading_day = " + tradingDayID);
                this.deleteViaPersistence(Shift.class, "SELECT finance_transaction.ID AS transaction_id FROM finance_transaction INNER JOIN finance_trading_day ON finance_transaction.FK_finance_trading_day = finance_trading_day.ID WHERE finance_transaction.FK_finance_trading_day = " + tradingDayID);
                ResultSet rs = null;
                try {
                    rs = this.dc.executeQuery("SELECT finance_shift.ID AS shift_id FROM finance_shift WHERE ID > 172");
                    while (rs.next()) {
                        long shiftId = rs.getLong("shift_id");
                        PersistenceManager.getPersistenceDelegate().delete(shiftId, Shift.class);
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            OrderMate.LOG.info("Successfully cleared trading day with ID " + tradingDayID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCashDrawerAssignments() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ResultSet resetTerminals = this.getResultSetFor("config_terminal", new String[]{"assigned_cashdrawers = 1"});
            try {
                if (resetTerminals == null) {
                    return;
                }
                while (resetTerminals.next()) {
                    this.setString("FK_config_user", null, "config_terminal_cashdrawer", resetTerminals.getLong("ID"));
                }
                this.dc.release(resetTerminals);
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List searchStreetDirectoryStreet(String streetName) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> matches = new ArrayList<String>();
            try {
                Object[] params = new Object[]{streetName + '%'};
                ResultSet rs = this.dc.executeQuery(this.getStreetDirectoryStreetPS().toString(), params);
                try {
                    while (rs.next()) {
                        matches.add(rs.getString("street_name"));
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return matches;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List searchStreetDirectorySuburb(String suburbName) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            ArrayList<String> matches = new ArrayList<String>();
            try {
                Object[] params = new Object[]{suburbName + '%'};
                ResultSet rs = this.dc.executeQuery(this.getStreetDirectorySuburbPS().toString(), params);
                try {
                    while (rs.next()) {
                        matches.add(rs.getString("suburb"));
                    }
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return matches;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCashDrawerUser(long CashDrawerD, long terminalID, long userID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setInt("FK_config_user", userID, "config_terminal_cashdrawer", new String[]{"FK_config_cashdrawer = " + CashDrawerD, "FK_config_terminal = " + terminalID});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockItemAverageCostPerUnit(long stockItemID, long stockAreaID, double newCost) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            if (Double.isNaN(newCost)) {
                throw new IllegalArgumentException("Attempting to set average cost of StockItem #" + stockItemID + " to a NaN value");
            }
            this.setDouble("AverageCost", newCost, "stock_on_hand", new String[]{"stock_on_hand.FK_stock_item = " + stockItemID, "stock_on_hand.FK_stock_area = " + stockAreaID});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockTakeDate(long stockTakeID, Date date) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            Timestamp tstamp = new Timestamp(date.getTime());
            this.setTimestamp("EndDate", tstamp, "stock_take", stockTakeID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockTakeEntryActualQty(long stockTakeEntryID, double qty) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setDouble("ActualQty", qty, "stock_take_entry", stockTakeEntryID);
        }
    }

    @Override
    public void setStockTakeUncountedToZero(long stockTakeID, long stockAreaID) throws RemoteException {
        Object[] params = new Long[]{stockTakeID, stockAreaID};
        this.execute(this.getSetStockTakeUncountedToZeroPS().toString(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageArea(long usageID, long stockAreaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setFKLink("FK_stock_area", stockAreaID, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageAreaTransferredTo(long usageID, long stockAreaID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setFKLink("FK_stock_area_transfer_to", stockAreaID, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageDate(long usageID, Date date) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setTimestamp("UsageDate", new Timestamp(date.getTime()), "stock_usage", usageID);
        }
    }

    @Override
    public void setStockUsageHistoricalCost(long usageID, double cost) throws RemoteException {
        this.setDouble("HistoricalCost", cost, "stock_usage", usageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageItem(long usageID, long stockItemID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setFKLink("FK_stock_item", stockItemID, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageQty(long usageID, double qty) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setDouble("Quantity", qty, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageReason(long usageID, String reason) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setString("Reason", reason, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageState(long usageID, String state) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setString("usage_state", state, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStockUsageUser(long usageID, long userID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            this.setFKLink("FK_config_user", userID, "stock_usage", usageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stockAreasExist() throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            try {
                ResultSet rs = this.dc.executeQuery(this.getStockAreasExistPS().toString());
                boolean exists = rs.next();
                this.dc.release(rs);
                return exists;
            }
            catch (SQLException e) {
                this.handleSQLError(e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stockTakeHasUncounted(long stockTakeID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            boolean hasUncounted = false;
            try {
                Object[] params = new Long[]{stockTakeID};
                ResultSet rs = this.dc.executeQuery(this.getStockTakeHasUncountedPS().toString(), params);
                try {
                    hasUncounted = rs.next();
                }
                finally {
                    this.dc.release(rs);
                }
            }
            catch (SQLException e) {
                this.handleSQLError(e);
            }
            return hasUncounted;
        }
    }

    @Override
    public void swapStockUsageComponent(long oldComponentID, long newComponentID) throws RemoteException {
        Object[] params = new Long[]{newComponentID, oldComponentID};
        this.execute(this.getSwapStockUsageComponentPS().toString(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInvoiceEntry(long invoiceEntryID, double numReceived, double bonusReceived, long stockItemID, long oldStockAreaID, long newStockAreaID, double pricePaid) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            StockInvoiceEntry existingEntry = PersistenceManager.getByID(invoiceEntryID, StockInvoiceEntry.class);
            StockItem oldItem = existingEntry.getStockItem();
            double oldPricePaid = existingEntry.getPricePaid().doubleValue();
            double oldQtyPerUnit = oldItem.getPurchaseQty().getRawValue();
            double oldTotalReceived = existingEntry.getTotalReceived() * oldQtyPerUnit;
            double newTotalReceived = 0.0;
            if (oldItem.getID() == stockItemID) {
                newTotalReceived = (numReceived + bonusReceived) * oldQtyPerUnit;
            } else {
                StockItem newStockItem = PersistenceManager.getByID(stockItemID, StockItem.class);
                double newQtyPerUnit = newStockItem.getPurchaseQty().getRawValue();
                newTotalReceived = (numReceived + bonusReceived) * newQtyPerUnit;
            }
            Data.database.adjustStockOnHand(oldItem.intID(), -oldTotalReceived, -oldPricePaid, oldStockAreaID, false);
            Data.database.adjustStockOnHand(stockItemID, newTotalReceived, pricePaid, newStockAreaID, false);
            Object[] params = new Object[]{new Double(numReceived), new Double(bonusReceived), new Double(stockItemID), new Double(pricePaid), invoiceEntryID};
            this.execute(this.getUpdateInvoiceEntryPS().toString(), params);
        }
    }

    @Override
    public void updateStockOnHand(long stockTakeEntryID, Quantity stockOnHand) throws RemoteException {
        Object[] params = new Object[]{new Double(stockOnHand.getRawValue()), stockTakeEntryID};
        this.execute(this.getUpdateStockEntryPS().toString(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStockTake(long stockTakeID) throws RemoteException {
        Object object = DatabaseService.getMutex();
        synchronized (object) {
            if (!this.getBool("Live", "stock_take", stockTakeID)) {
                return false;
            }
            Object[] params = new Long[]{stockTakeID};
            this.execute(this.getUpdateStockTakeTheoreticalFromSOHPS().toString(), params);
            params = new Long[]{stockTakeID};
            this.execute(this.getUpdateStockTakeActualToSOHPS().toString(), params);
            Timestamp lastStockTakeDate = new Timestamp(0L);
            StockTake lastSavedStockTake = StockTake.getLastSavedStockTake();
            if (lastSavedStockTake != null) {
                lastStockTakeDate = new Timestamp(lastSavedStockTake.getDate().getTime());
            }
            Object[] params2 = new Object[]{lastStockTakeDate};
            this.execute(this.getUpdateStockTakeHistoricalUsageDataPS().toString(), params2);
            params2 = new Long[]{stockTakeID};
            this.execute(this.getUpdateStockTakeCostPerUnitPS().toString(), params2);
            this.setBool("Live", false, "stock_take", stockTakeID);
            this.setTimestamp("EndDate", new Timestamp(System.currentTimeMillis()), "stock_take", stockTakeID);
            return true;
        }
    }

    private ObjectQuery getAdjustAllInvoiceQuantitiesPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_invoice_entry SET NumReceived = NumReceived * ?, BonusReceived = BonusReceived * ? WHERE FK_stock_item = ? ");
    }

    private ObjectQuery getFindInventoryItemUnitPS() {
        return new ObjectQuerySQLAdapter("SELECT inventory_item_unit.* FROM inventory_item_unit, inventory_item, inventory_size, inventory_portion, inventory_group, inventory_profile WHERE inventory_item.Name = ? AND inventory_size.Name = ? AND inventory_portion.Name = ? AND inventory_profile.ID = ? AND inventory_item_unit.FK_inventory_item = inventory_item.ID AND inventory_item_unit.FK_inventory_size = inventory_size.ID AND inventory_item_unit.FK_inventory_portion = inventory_portion.ID AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.FK_inventory_profile = inventory_profile.ID AND inventory_item_unit.SYSTEM_STATE = 'Active'");
    }

    private ObjectQuery getGetAreaStockOnHandForItemPS() {
        return new ObjectQuerySQLAdapter("SELECT Quantity FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? AND stock_on_hand.system_state = 'ACTIVE'");
    }

    private ObjectQuery getGetBarcodeIDPS() {
        return new ObjectQuerySQLAdapter("SELECT ID FROM inventory_item_unit_barcodes WHERE barcode = ?");
    }

    private ObjectQuery getGetBarcodesForStockItemPS() {
        return new ObjectQuerySQLAdapter("SELECT stock_barcodes.barcode FROM stock_item, stock_barcodes WHERE stock_item.ID = ? AND stock_barcodes.FK_stock_item = stock_item.ID AND stock_item.system_state = 'ACTIVE' ORDER BY stock_barcodes.barcode");
    }

    private ObjectQuery getGetCashDrawerSummaryPS() {
        return new ObjectQuerySQLAdapter("SELECT finance_unit.ID as unit_id, finance_unit.Name as unit_name, finance_unit.unit_type as unit_type, finance_unit.skimmable as skimmable, finance_transaction.FK_config_cashdrawer AS cashdrawer_id, SUM(finance_transaction.amount_paid) AS total FROM finance_transaction, finance_unit WHERE finance_unit.system_state = 'ACTIVE' AND finance_unit.unit_type <> 'PETTY_CASH' AND finance_unit.unit_type <> 'OVER_CHARGE' AND finance_transaction.FK_finance_unit = finance_unit.ID AND finance_transaction.system_state <> 'DELETED' AND finance_transaction.FK_finance_transaction IS NULL AND finance_transaction.FK_config_cashdrawer = ? AND finance_transaction.FK_finance_shift = ? GROUP BY unit_id");
    }

    private ObjectQuery getAppliedPreviousTransactions(Shift shift) {
        return new ObjectQuerySQLAdapter("SELECT SUM( if(finance_transaction.timestamp BETWEEN ? AND ?, finance_transaction.amount_paid, 0)) as 'rangeTotal', SUM( if(finance_transaction.timestamp BETWEEN ? AND ?, 0, finance_transaction.amount_paid)) as 'other' from finance_transaction left join finance_transaction as linked_transaction on finance_transaction.fk_finance_transaction = linked_transaction.id left join sales_account on sales_account.id = finance_transaction.fk_payoff_account where linked_transaction.id is not null AND sales_account.fk_finance_shift = " + shift.getID() + " AND finance_transaction.system_state = 'ACTIVE'");
    }

    private ObjectQuery getGetCashDrawerTipsPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS total FROM finance_transaction WHERE FK_config_cashdrawer = ? AND FK_finance_shift = ? AND system_state = 'ACTIVE'");
    }

    private ObjectQuery getGetTotalCashoutPS(CashDrawer drawer, Shift shift) {
        return Query.sum(FinanceTransaction.Properties.CASH_OUT, "total").active(FinanceTransaction.class).equals(FinanceTransaction.Properties.CASH_DRAWER, drawer).equals(FinanceTransaction.Properties.SHIFT, shift);
    }

    private ObjectQuery getGetComponentUsageCostPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(HistoricalCost) / SUM(stock_usage.Quantity) AS AvgCost FROM stock_usage WHERE FK_sales_component = ? AND FK_stock_item = ? AND (stock_usage.system_state = 'ACTIVE' OR stock_usage.system_state = 'CLONED')AND usage_state = 'NORMAL'");
    }

    private ObjectQuery getGetEmailPermissionsPS() {
        return new ObjectQuerySQLAdapter("SELECT email FROM config_command_permission, config_command WHERE config_command_permission.system_state = 'ACTIVE' AND config_command_permission.FK_config_command = config_command.ID AND config_command.internal_name = ? ");
    }

    private ObjectQuery getGetInventoryItemUnitBarcodePS() {
        return new ObjectQuerySQLAdapter("SELECT barcode FROM inventory_item_unit_barcodes, inventory_item_unit_barcodes_link WHERE inventory_item_unit_barcodes_link.FK_inventory_item_unit = ? AND inventory_item_unit_barcodes_link.FK_inventory_item_unit_barcodes = inventory_item_unit_barcodes.ID");
    }

    private ObjectQuery getGetLastSavedStockTakePS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_take WHERE " + SQL.isActive("stock_take") + "AND Live = 0 ORDER BY EndDate DESC LIMIT 1");
    }

    private ObjectQuery getGetLastStockTakePS() {
        return new ObjectQuerySQLAdapter("SELECT id FROM stock_take ORDER BY EndDate DESC, id desc LIMIT 1");
    }

    private ObjectQuery getGetFirstStockTakePS() {
        return new ObjectQuerySQLAdapter("SELECT id FROM stock_take WHERE system_state = 'ACTIVE' ORDER BY EndDate ASC LIMIT 1");
    }

    private ObjectQuery getGetLiveStockTakePS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_take WHERE Live = 1 AND " + SQL.isActive("stock_take") + "LIMIT 1");
    }

    private ObjectQuery getGetPhonePermissionsPS() {
        return new ObjectQuerySQLAdapter("SELECT phone FROM config_command_permission, config_command WHERE config_command_permission.system_state = 'ACTIVE' AND config_command_permission.FK_config_command = config_command.ID AND config_command.internal_name = ? ");
    }

    private ObjectQuery getGetSavedStockTakesPS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_take WHERE " + SQL.isActive("stock_take") + "AND Live = 0 ORDER BY EndDate DESC");
    }

    private ObjectQuery getGetStockAreaTotalAdjustmentValuePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM((stock_on_hand.AverageCost/stock_item.Quantity) * ABS(stock_usage.Quantity)) AS Value, SUM(ABS(stock_usage.HistoricalCost)) AS Historical FROM stock_usage, stock_item, stock_on_hand WHERE stock_usage.usage_state = 'ADJUST' AND stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_usage.FK_stock_area AND " + SQL.isActive("stock_usage") + "AND " + SQL.join("stock_usage", "stock_item") + "AND stock_usage.FK_stock_area = ? AND CreationDate >= ? AND CreationDate <= ? ");
    }

    private ObjectQuery getGetStockAreaTotalIncomingTransferValuePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(HistoricalCost) AS Historical, SUM((stock_on_hand.AverageCost/stock_item.Quantity) * stock_usage.Quantity) AS Value FROM stock_item, stock_usage, stock_on_hand WHERE stock_usage.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_item = stock_usage.FK_stock_item AND stock_on_hand.FK_stock_area = stock_usage.FK_stock_area AND stock_usage.FK_stock_area = ? AND stock_usage.CreationDate >= ? AND stock_usage.CreationDate <= ? AND stock_usage.usage_state = 'TRANSFER' AND " + SQL.isActive("stock_usage"));
    }

    private ObjectQuery getGetStockAreaTotalInvoiceExtrasValuePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(AdminCost + FreightCost - Discount) AS Value FROM stock_invoice WHERE stock_invoice.FK_stock_area = ? AND stock_invoice.CreationDate >= ? AND stock_invoice.CreationDate <= ? AND " + SQL.isActive("stock_invoice"));
    }

    private ObjectQuery getGetStockAreaTotalInvoiceValuePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(stock_invoice_entry.PricePaid) AS Value FROM stock_invoice_entry, stock_invoice WHERE " + SQL.join("stock_invoice_entry", "stock_invoice") + "AND stock_invoice.FK_stock_area = ? AND stock_invoice.CreationDate >= ? AND stock_invoice.CreationDate <= ? AND " + SQL.isActive("stock_invoice") + "AND " + SQL.isActive("stock_invoice_entry"));
    }

    private ObjectQuery getGetStockAreaTotalOutgoingTransferValuePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(HistoricalCost) AS Historical, SUM((stock_on_hand.AverageCost/stock_item.Quantity) * stock_usage.Quantity) AS Value FROM stock_item, stock_usage, stock_on_hand WHERE stock_usage.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_item = stock_usage.FK_stock_item AND stock_on_hand.FK_stock_area = stock_usage.FK_stock_area AND stock_usage.FK_stock_area_transfer_to = ? AND stock_usage.CreationDate >= ? AND stock_usage.CreationDate <= ? AND stock_usage.usage_state = 'TRANSFER' AND " + SQL.isActive("stock_usage"));
    }

    private ObjectQuery getGetStockAreaTotalWastageValuePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(HistoricalCost) AS Historical, SUM(stock_on_hand.AverageCost * stock_usage.Quantity / stock_item.Quantity) AS Value FROM stock_item, stock_usage, stock_on_hand WHERE stock_usage.FK_stock_area = ? AND stock_usage.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_item = stock_usage.FK_stock_item AND stock_on_hand.FK_stock_area = stock_usage.FK_stock_area AND " + SQL.isActive("stock_usage") + "AND stock_usage.usage_state = '" + "WASTED" + "' AND stock_usage.CreationDate >= ? AND stock_usage.CreationDate <= ? ");
    }

    private ObjectQuery getGetStockTakeAreaCurrentCostVariancePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(IF (tax_included, ((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)  * " + this.taxFactor + ") / stock_item.Quantity),((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)) / stock_item.Quantity))) AS VarianceVal FROM stock_take_entry, stock_item, stock_on_hand WHERE stock_take_entry.FK_stock_take = ? AND stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND stock_take_entry.FK_stock_area = ? AND " + SQL.join("stock_take_entry", "stock_item") + "AND " + SQL.isActive("stock_take_entry"));
    }

    private ObjectQuery getGetStockTakeTotalCurrentCostVariancePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(IF (tax_included, ((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)  * " + this.taxFactor + ") / stock_item.Quantity),((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)) / stock_item.Quantity))) AS VarianceVal FROM stock_take_entry, stock_item, stock_on_hand WHERE stock_take_entry.FK_stock_take = ? AND stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND stock_take_entry.FK_stock_item = stock_item.ID AND " + SQL.isActive("stock_take_entry"));
    }

    private ObjectQuery getGetStockTakeAreaVarianceLivePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(IF (tax_included, ((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)  * " + this.taxFactor + ") / stock_item.Quantity),((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)) / stock_item.Quantity))) AS VarianceVal FROM stock_take_entry, stock_on_hand, stock_item WHERE stock_take_entry.FK_stock_take = ? AND " + SQL.join("stock_take_entry", "stock_item") + "AND stock_on_hand.FK_stock_item = stock_take_entry.FK_stock_item AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND (stock_on_hand.quantity <> stock_take_entry.ActualQty)AND " + SQL.isActive("stock_take_entry") + "AND stock_take_entry.FK_stock_area = ? ");
    }

    private ObjectQuery getGetStockTakeTotalVarianceLivePS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(IF (tax_included, ((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)  * " + this.taxFactor + ") / stock_item.Quantity),((stock_on_hand.AverageCost * (ActualQty - stock_on_hand.Quantity)) / stock_item.Quantity))) AS VarianceVal FROM stock_take_entry, stock_on_hand, stock_item WHERE stock_take_entry.FK_stock_take = ? AND " + SQL.join("stock_take_entry", "stock_item") + "AND stock_on_hand.FK_stock_item = stock_take_entry.FK_stock_item AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND (NOT (stock_on_hand.StockAllowed = 0) OR NOT (stock_on_hand.Quantity = 0.0)) AND " + SQL.isActive("stock_take_entry"));
    }

    private ObjectQuery getGetStockTakeTotalVarianceSavedPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(IF (tax_included, CostPerAtomicUnit * (ActualQty - TheoreticalQty) * " + this.taxFactor + ", CostPerAtomicUnit * (ActualQty - TheoreticalQty))) AS VarianceVal FROM stock_take_entry JOIN stock_item on stock_take_entry.FK_stock_item = stock_item.ID WHERE stock_take_entry.FK_stock_take = ? AND " + SQL.isActive("stock_take_entry"));
    }

    private ObjectQuery getGetStockTakeAreaVarianceSavedPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(IF (tax_included, CostPerAtomicUnit * (ActualQty - TheoreticalQty) * " + this.taxFactor + ", CostPerAtomicUnit * (ActualQty - TheoreticalQty))) AS VarianceVal FROM stock_on_hand, stock_take_entry JOIN stock_item on stock_take_entry.FK_stock_item = stock_item.ID WHERE stock_take_entry.FK_stock_take = ? AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND stock_on_hand.FK_stock_item = stock_take_entry.FK_stock_item AND (stock_take_entry.TheoreticalQty <> stock_take_entry.ActualQty) AND (NOT (stock_on_hand.StockAllowed = 0) OR NOT (stock_on_hand.Quantity = 0.0)) AND " + SQL.isActive("stock_take_entry") + "AND stock_take_entry.FK_stock_area = ? ");
    }

    private ObjectQuery getGetStockTakeEntriesPS() {
        return new ObjectQuerySQLAdapter("SELECT stock_take_entry.ID, stock_take_entry.TheoreticalQty, stock_take_entry.ActualQty, stock_item.Name, stock_item.ID AS itemID, stock_item.DisplayMeasureUnit FROM stock_take_entry, stock_item, stock_on_hand, stock_take WHERE stock_take_entry.FK_stock_take = stock_take.ID AND stock_take.ID = ? AND stock_take_entry.FK_stock_area = ? AND (stock_on_hand.StockAllowed = 1 OR (Live = 1 AND stock_on_hand.Quantity <> 0) OR (Live = 0 AND stock_take_entry.TheoreticalQty <> 0)) AND stock_on_hand.FK_stock_area = ? AND stock_take_entry.FK_stock_item = stock_item.ID AND stock_item.FK_stock_group = ? AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND stock_on_hand.FK_stock_item = stock_item.ID ORDER BY stock_item.Name ASC");
    }

    private ObjectQuery getGetStockTakePS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_take WHERE ID = ?");
    }

    private ObjectQuery getGetStockTakesForDateRangePS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_take WHERE " + SQL.isActive("stock_take") + "AND stock_take.EndDate > ? AND stock_take.EndDate <= ? ");
    }

    private ObjectQuery getGetStockUsagePS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_usage WHERE usage_state = ? AND UsageDate >= ? AND UsageDate <= ? AND system_state = 'ACTIVE' ORDER BY UsageDate DESC");
    }

    private ObjectQuery getGetStockWastageByID() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_usage WHERE ID = ? AND usage_state = ? ");
    }

    private ObjectQuery getGetSubStockGroupsPS() {
        return new ObjectQuerySQLAdapter("SELECT * FROM stock_group WHERE FK_stock_group = ? AND system_state = 'ACTIVE' ORDER BY 'Name'");
    }

    private ObjectQuery getGetTotalSOHValueForAreaPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM((stock_on_hand.AverageCost * stock_on_hand.Quantity) / stock_item.Quantity) AS Value FROM stock_on_hand, stock_item WHERE stock_on_hand.FK_stock_area = ? AND stock_on_hand.FK_stock_item = stock_item.ID AND " + SQL.isActive("stock_item") + "AND " + SQL.isActive("stock_on_hand"));
    }

    private ObjectQuery getGetTotalStockOnHandForItemPS() {
        return new ObjectQuerySQLAdapter("SELECT sum(Quantity) as TotalQty FROM stock_on_hand inner join stock_area on stock_on_hand.fk_stock_area=stock_area.id WHERE FK_stock_item = ? AND stock_on_hand.system_state = 'ACTIVE' AND stock_area.system_state = 'ACTIVE'");
    }

    private ObjectQuery getIsInventoryItemUnitStockOverSoldPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(stock_on_hand.Quantity) < stock_inventory_item_unit.Quantity * ? AS OverSold FROM stock_on_hand, stock_item, stock_inventory_item_unit WHERE stock_on_hand.FK_stock_item = stock_item.ID AND stock_inventory_item_unit.FK_stock_item = stock_item.ID AND stock_inventory_item_unit.FK_inventory_item_unit = ? GROUP BY stock_inventory_item_unit.FK_inventory_item_unit");
    }

    private ObjectQuery getSetStockTakeUncountedToZeroPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry, stock_take SET stock_take_entry.ActualQty = 0 WHERE stock_take_entry.ActualQty IS NULL AND stock_take_entry.FK_stock_take = stock_take.ID AND stock_take.ID = ? AND stock_take_entry.FK_stock_area = ? ");
    }

    private ObjectQuery getStockAreasExistPS() {
        return new ObjectQuerySQLAdapter("SELECT 1 FROM stock_area WHERE " + SQL.isActive("stock_area") + " LIMIT 1");
    }

    private ObjectQuery getStockTakeHasUncountedPS() {
        return new ObjectQuerySQLAdapter("SELECT stock_take_entry.ID AS NumUncounted FROM stock_take_entry, stock_on_hand WHERE stock_take_entry.FK_stock_take = ? AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND stock_on_hand.FK_stock_item = stock_take_entry.FK_stock_item AND stock_on_hand.StockAllowed AND (unit_qty IS NULL OR outer_qty IS NULL) LIMIT 1");
    }

    private ObjectQuery getStreetDirectoryStreetPS() {
        return new ObjectQuerySQLAdapter("SELECT DISTINCT street_name FROM street_directory_ref WHERE street_name LIKE ?");
    }

    private ObjectQuery getStreetDirectorySuburbPS() {
        return new ObjectQuerySQLAdapter("SELECT DISTINCT suburb FROM street_directory_ref WHERE suburb LIKE ?");
    }

    private ObjectQuery getSwapStockUsageComponentPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_usage SET FK_sales_component = ? WHERE FK_sales_component = ? ");
    }

    private ObjectQuery getUpdateInvoiceEntryPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_invoice_entry SET NumReceived = ?, BonusReceived = ?, FK_stock_item = ?, PricePaid = ? WHERE ID = ? ");
    }

    private ObjectQuery getUpdateStockEntryPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry SET ActualQty = ? WHERE ID = ? ");
    }

    private ObjectQuery getUpdateStockTakeActualToSOHPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry, stock_on_hand SET stock_on_hand.Quantity = stock_take_entry.ActualQty WHERE stock_take_entry.FK_stock_take = ? AND stock_take_entry.ActualQty IS NOT NULL AND stock_take_entry.FK_stock_area = stock_on_hand.FK_stock_area AND stock_take_entry.FK_stock_item = stock_on_hand.FK_stock_item AND " + SQL.isActive("stock_take_entry") + "AND " + SQL.isActive("stock_on_hand"));
    }

    private ObjectQuery getUpdateStockTakeCostPerUnitPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry, stock_item, stock_on_hand SET stock_take_entry.CostPerAtomicUnit = stock_on_hand.AverageCost / stock_item.Quantity WHERE stock_take_entry.FK_stock_take = ? AND stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area AND stock_take_entry.FK_stock_item = stock_item.ID ");
    }

    ObjectQuery getUpdateStockTakeHistoricalUsageDataPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_usage, stock_item, stock_on_hand SET stock_usage.HistoricalCost = stock_on_hand.AverageCost * stock_usage.Quantity / stock_item.Quantity WHERE stock_usage.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_usage.FK_stock_area AND stock_usage.CreationDate > ? AND stock_usage.HistoricalCost IS NULL ");
    }

    private ObjectQuery getUpdateStockTakeTheoreticalFromSOHPS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry, stock_on_hand SET stock_take_entry.TheoreticalQty = stock_on_hand.Quantity WHERE stock_take_entry.FK_stock_take = ? AND stock_take_entry.FK_stock_area = stock_on_hand.FK_stock_area AND stock_take_entry.FK_stock_item = stock_on_hand.FK_stock_item AND " + SQL.isActive("stock_take_entry") + "AND " + SQL.isActive("stock_on_hand"));
    }

    private ObjectQuery getUpdateStockValuesForUnitChange_OptionsLink_PS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_inventory_mod_link SET stock_inventory_mod_link.Quantity = stock_inventory_mod_link.Quantity * ? WHERE stock_inventory_mod_link.FK_stock_item = ? AND stock_inventory_mod_link.type = 'OPTION_LINK'");
    }

    private ObjectQuery getUpdateStockValuesForUnitChange_SOH_PS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_on_hand SET Quantity = Quantity * ? WHERE FK_stock_item = ? ");
    }

    private ObjectQuery getUpdateStockValuesForUnitChange_StockTakes_PS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_take_entry, stock_item, stock_on_hand SET TheoreticalQty = TheoreticalQty * ?,  ActualQty = ActualQty *  ?,  CostPerAtomicUnit = stock_on_hand.AverageCost / stock_item.Quantity WHERE stock_item.ID = ? AND stock_take_entry.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_item = stock_item.ID AND stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area");
    }

    private ObjectQuery getUpdateStockValuesForUnitChange_UnitsLink_PS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_inventory_item_unit SET stock_inventory_item_unit.Quantity = stock_inventory_item_unit.Quantity * ? WHERE stock_inventory_item_unit.FK_stock_item = ? ");
    }

    private ObjectQuery getUpdateStockValuesForUnitChange_Usage_PS() {
        return new ObjectQuerySQLAdapter("UPDATE stock_usage SET Quantity = Quantity * ? WHERE FK_stock_item = ? ");
    }

    public double getSumQueryResult(ObjectQuery query, Object[] params, String resultName) throws SQLException {
        double result = 0.0;
        ResultSet rs = this.dc.executeQuery(query.toString(), params);
        while (rs.next()) {
            result = rs.getDouble(resultName);
        }
        this.dc.release(rs);
        return result;
    }
}

