/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ordermate.dbconnection.AbstractDatabaseConnection;

public class DatabaseTools {
    public static void executeAndClose(PreparedStatement statement) throws SQLException {
        if (statement == null) {
            Logger.getGlobal().log(Level.WARNING, "Could not execute null statement");
            return;
        }
        try {
            statement.execute();
        }
        finally {
            statement.close();
        }
    }

    public static PreparedStatement createDeleteWhereNoFK(AbstractDatabaseConnection dc, String deleteTable, String otherTable, String fkCol) {
        PreparedStatement toReturn = dc.createPreparedStatement("DELETE " + deleteTable + " FROM " + deleteTable + " LEFT JOIN " + otherTable + " ON " + deleteTable + "." + fkCol + " = " + otherTable + ".ID  WHERE " + otherTable + ".ID  IS NULL AND " + deleteTable + ".ID IS NOT NULL");
        return toReturn;
    }

    public static void executeSQLScript(AbstractDatabaseConnection dc, String scriptName, Map substitutions) throws IOException, SQLException {
        BufferedReader scriptReader = new BufferedReader(new BufferedReader(new InputStreamReader(dc.getClass().getResourceAsStream(scriptName))));
        StringBuffer contentsBuffer = new StringBuffer(1000);
        String currentLine = scriptReader.readLine();
        String sql = null;
        try (Statement statement = null;){
            statement = dc.createStatement();
            while (currentLine != null) {
                if (!currentLine.startsWith("--") && !currentLine.startsWith("#") && currentLine.length() != 0) {
                    contentsBuffer.append(currentLine);
                    if (currentLine.indexOf(";") != -1) {
                        sql = contentsBuffer.substring(0, contentsBuffer.lastIndexOf(";"));
                        contentsBuffer.delete(0, contentsBuffer.length());
                        for (String key : substitutions.keySet()) {
                            String value = (String)substitutions.get(key);
                            StringBuffer buf = new StringBuffer(sql.length());
                            int start = 0;
                            int end = 0;
                            while ((end = sql.indexOf(key, start)) != -1) {
                                buf.append(sql.substring(start, end)).append(value);
                                start = end + key.length();
                            }
                            buf.append(sql.substring(start));
                            sql = buf.toString();
                        }
                        if (sql.length() > 0) {
                            statement.execute(sql);
                            Thread.yield();
                        }
                    }
                }
                currentLine = scriptReader.readLine();
            }
        }
    }

    protected static void resetDB(AbstractDatabaseConnection dc) throws SQLException {
        String dbName = dc.getDatabaseName();
        PreparedStatement dropDb = dc.createPreparedStatement("DROP DATABASE IF EXISTS " + dbName);
        DatabaseTools.executeAndClose(dropDb);
        PreparedStatement createDb = dc.createPreparedStatement("CREATE DATABASE " + dbName);
        DatabaseTools.executeAndClose(createDb);
        PreparedStatement useDb = dc.createPreparedStatement("USE " + dbName);
        DatabaseTools.executeAndClose(useDb);
        dc.getDBConnection().setCatalog(dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean indexExistsByName(String tableName, String indexName, AbstractDatabaseConnection dc) throws SQLException {
        PreparedStatement getIndexesPS = dc.createPreparedStatement("SHOW INDEX FROM " + tableName);
        ResultSet rs = null;
        boolean found = false;
        try {
            rs = getIndexesPS.executeQuery();
            while (rs.next()) {
                String keyName = rs.getString("Key_name");
                if (!indexName.equalsIgnoreCase(keyName)) continue;
                found = true;
                break;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getGlobal().log(Level.SEVERE, "Could not close off the result set after checking for index existence.");
                }
            }
        }
        return found;
    }

    public static boolean indexExists(String tableName, String column, AbstractDatabaseConnection dc) throws SQLException {
        return DatabaseTools.indexExists(tableName, new String[]{column}, dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean indexExists(String tableName, String[] columns, AbstractDatabaseConnection dc) throws SQLException {
        PreparedStatement getIndexesPS = dc.createPreparedStatement("SHOW INDEX FROM " + tableName);
        ResultSet rs = null;
        try {
            rs = getIndexesPS.executeQuery();
            int matched = 0;
            String currentKey = null;
            int currentKeyCount = 0;
            while (rs.next()) {
                String keyName = rs.getString("Key_name");
                String column = rs.getString("Column_name");
                if (currentKey == null) {
                    currentKey = keyName;
                    currentKeyCount = 0;
                } else if (currentKey.equals(keyName)) {
                    ++currentKeyCount;
                } else {
                    currentKeyCount = 0;
                    matched = 0;
                }
                currentKey = keyName;
                matched = currentKeyCount == matched && column.toLowerCase().equals(columns[matched].toLowerCase()) ? ++matched : 0;
                if (matched != columns.length) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            dc.release(rs);
        }
    }
}

