/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.persistence.SaveContext;
import java.io.Serializable;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.User;

public class EventContext
implements SaveContext,
Serializable {
    private final Terminal terminal;
    private final User user;
    private final Shift shift;
    private final TradingDay tradingDay;

    public static EventContext getContextDoNotUse() {
        return new EventContext(new User());
    }

    public EventContext(User newUser) {
        this.user = newUser;
        this.terminal = Terminal.getLocalHost();
        this.shift = this.terminal.getShift();
        this.tradingDay = TradingDay.getCurrentTradingDay();
    }

    protected EventContext(EventContext toCopy) {
        this.user = toCopy.user;
        this.terminal = toCopy.terminal;
        this.tradingDay = toCopy.tradingDay;
        this.shift = toCopy.shift;
    }

    public EventContext(Terminal newTerminal, User newUser) {
        this.terminal = newTerminal;
        this.user = newUser;
        this.shift = this.terminal != null ? this.terminal.getShift() : null;
        TradingDay day = null;
        try {
            day = TradingDay.getCurrentTradingDay();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Could not get current trading day from database");
        }
        this.tradingDay = day != null ? day : (this.shift != null ? this.shift.getTradingDay() : null);
    }

    public EventContext(Terminal newTerminal, User newUser, TradingDay newTradingDay, Shift newShift) {
        this.terminal = newTerminal;
        this.user = newUser;
        this.tradingDay = newTradingDay;
        this.shift = newShift;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public User getUser() {
        return this.user;
    }

    public TradingDay getTradingDay() {
        return this.tradingDay;
    }

    public Shift getShift() {
        return this.shift;
    }
}

