/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.inventory.InventoryBarcode;
import ordermate.database.inventory.InventoryItemUnit;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_item_unit_barcodes_link")
@AccessType(value="property")
public class InventoryItemUnitBarcodeLink
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryItemUnit> itemUnit;
    private Reference<InventoryBarcode> barcode;

    public InventoryItemUnitBarcodeLink() {
        this.itemUnit = this.createReference(InventoryItemUnitBarcodeLink.Properties.ITEM_UNIT);
        this.barcode = this.createReference(InventoryItemUnitBarcodeLink.Properties.BARCODE);
    }

    public InventoryItemUnitBarcodeLink(InventoryItemUnit unit, InventoryBarcode code) {
        this.itemUnit = this.createReference(InventoryItemUnitBarcodeLink.Properties.ITEM_UNIT);
        this.barcode = this.createReference(InventoryItemUnitBarcodeLink.Properties.BARCODE);
        this.setItemUnit(unit);
        this.setBarcode(code);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_item_unit")
    public InventoryItemUnit getItemUnit() {
        return this.itemUnit.get();
    }

    public void setItemUnit(InventoryItemUnit unit) {
        this.itemUnit.set(unit);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_item_unit_barcodes")
    public InventoryBarcode getBarcode() {
        return this.barcode.get();
    }

    public void setBarcode(InventoryBarcode newBarcode) {
        this.barcode.set(newBarcode);
    }

    @Override
    public void deleteChild() {
        InventoryBarcode code;
        PersistenceManager.deleteChild(this);
        if (this.getBarcode() != null && this.getBarcode().isPersistent() && (code = (InventoryBarcode)PersistenceManager.reacquire(this.getBarcode())).getItemUnits().size() == 0) {
            code.delete();
        }
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void saveChild() {
        if (this.getBarcode() == null || this.getItemUnit() == null) {
            this.deleteChild();
        } else {
            if (!this.getItemUnit().isPersistent()) {
                throw new IllegalStateException("Cannot save barcode link with non-persistent item unit");
            }
            this.getBarcode().save();
            PersistenceManager.saveChild(this);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property ITEM_UNIT;
        public PropertiedObject.Property BARCODE;
    }
}

