/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.transactions.FinanceTransaction;

public interface Payable<T extends PersistentObjectI>
extends Saveable,
Displayable {
    public static final PaidState PAID = new PaidState("Paid", 1);
    public static final PaidState NOT_PAID = new PaidState("Unpaid", 2);
    public static final PaidState UNPAYABLE = new PaidState("Unpayable", 3);
    public static final PaidState CREDIT = new PaidState("Credit", 4);
    public static final PaidState UNPAYABLE_BY_ROUNDING = new PaidState("Unpayable By Rounding", 5);

    public boolean allowsPayingIntoCredit();

    public Price getTotal();

    public Price getDue();

    public Price getDue(double var1);

    public Price getPaid();

    public Price getTendered();

    public boolean isPaidModifiable();

    public List<FinanceTransaction> getFinanceTransactions();

    public void addFinanceTransaction(FinanceTransaction var1);

    public void removeFinanceTransaction(FinanceTransaction var1);

    public PaidState getPaidState();

    public void pay();

    public List<FinanceTransactionDocket> getEftposDockets();

    public boolean hasEftposDockets();

    public static final class PaidState {
        String label;
        int intValue;

        private PaidState(String descriptionLabel, int enumValue) {
            this.label = descriptionLabel;
            this.intValue = enumValue;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class PayableValidator {
        public static final void validate(Payable payable) {
            if (!MathsUtils.approxEquals(payable.getTotal().subtract(payable.getPaid()).doubleValue(), payable.getDue().doubleValue())) {
                throw new IllegalStateException("payable is in an invalid state: total less paid does not equal due.  Paid: " + payable.getPaid() + "  Total: " + payable.getTotal() + "  Due: " + payable.getDue());
            }
        }
    }
}

