/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;

public class PayableHelper {
    private PayableHelper() {
    }

    public static final boolean hasEftposDockets(List<FinanceTransaction> txns) {
        boolean found = false;
        for (FinanceTransaction nextTxn : txns) {
            if (!(nextTxn instanceof EftposTransaction && StringUtils.isEmpty(((EftposTransaction)nextTxn).getTipReference()) && "DELETED".equals(nextTxn.getSystemState()) && nextTxn.getSubType() == null || !nextTxn.usesEftpos() || !(found = ((EftposTransaction)nextTxn).hasDockets()))) break;
        }
        return found;
    }

    public static final List<FinanceTransactionDocket> getEftposDockets(List<FinanceTransaction> txns) {
        ArrayList<FinanceTransactionDocket> list = new ArrayList<FinanceTransactionDocket>();
        for (FinanceTransaction nextTxn : txns) {
            if (!nextTxn.usesEftpos()) continue;
            list.addAll(((EftposTransaction)nextTxn).getDockets());
        }
        return list;
    }
}

