/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.persistence.CSVPropertiedObjExporter;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;

public class PosChangeLogger {
    private List<PosChange> changes = new ArrayList<PosChange>();

    public void reset() {
        this.changes.clear();
    }

    public List<PosChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public void markDeleted(PersistentObject obj) {
        if (obj.isPersistent()) {
            this.changes.add(new PosChange(ChangeType.Delete, obj.getClass(), obj.getID(), obj.toString()));
        }
    }

    public void detectChange(PersistentObject obj) {
        if (obj.isPersistent()) {
            PersistentObjectSnapshot oldSnappy = obj.getLastSavedSnapshot();
            PersistentObjectSnapshot newSnappy = obj.getSnapshot();
            StringBuilder SB = new StringBuilder();
            for (PropertiedObject.Property<?> prop : newSnappy.getProperties()) {
                if (PersistentObject.Properties.VERSION.equals(prop)) continue;
                Object newThing = newSnappy.get(prop);
                Object oldThing = oldSnappy.get(prop);
                if ((oldThing == null || oldThing.equals(newThing)) && (oldThing != null || newThing == null)) continue;
                SB.append(prop.getName()).append(" was '").append(oldThing).append("' now '").append(newThing).append("', ");
            }
            if (SB.length() != 0) {
                this.changes.add(new PosChange(ChangeType.Edit, obj.getClass(), obj.getID(), SB.substring(0, SB.length() - 2)));
            }
        } else {
            this.changes.add(new PosChange(ChangeType.New, obj.getClass(), null, obj.toString()));
        }
    }

    public String getAsCsv() {
        CSVPropertiedObjExporter<PosChange> changeExporter = new CSVPropertiedObjExporter<PosChange>(PosChange.class, Collections.emptySet());
        StringWriter writer = new StringWriter();
        try {
            changeExporter.export(writer, this.changes);
            writer.flush();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot export changes to CSV", (Throwable)ex);
        }
        return writer.getBuffer().toString();
    }

    public static class PosChange
    implements PropertiedObject {
        public static final Props Properties = new Props();
        private final ChangeType type;
        private final Class clazz;
        private final Long id;
        private final String description;

        PosChange(ChangeType type, Class clazz, Long id, String description) {
            this.type = type;
            this.clazz = clazz;
            this.id = id;
            this.description = description;
        }

        public ChangeType getType() {
            return this.type;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Long getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public Props getProperties() {
            return Properties;
        }

        @Override
        public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
            return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
        }

        public static class Props
        extends PropertiedObject.Props {
            public PropertiedObject.Property<ChangeType> TYPE;
            public PropertiedObject.Property<Class> CLAZZ;
            public PropertiedObject.Property<Long> ID;
            public PropertiedObject.Property<String> DESCRIPTION;
        }
    }

    public static enum ChangeType {
        New,
        Edit,
        Delete;

    }
}

