/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database;

import au.com.ordermate.util.file.FileUtils;
import java.io.File;
import ordermate.OrderMate;
import ordermate.database.AbstractUpdateConfigExecutable;
import ordermate.database.misc.application.Application;

public class UpdateJnlpExecutable
extends AbstractUpdateConfigExecutable {
    private static final String WAITER = "waitermate.jnlp";
    private static final String OFFICE = "officeMate.jnlp";
    private static final String SERVER = "servermate.jnlp";
    private static final String KTS = "touchprepxpress.jnlp";

    public UpdateJnlpExecutable(Application[] theTerminalTypes, String replaceStartsWith, String withThis) {
        super(theTerminalTypes, replaceStartsWith, withThis, " ");
    }

    @Override
    protected String getPathToFiles() {
        File progFile = FileUtils.findProgramFileDirectory();
        if (progFile == null) {
            OrderMate.LOG.error("Cannot find the Program Files directory!");
            return "";
        }
        return FileUtils.toPath(true, progFile.getAbsolutePath(), "OrderMate", "Apache Group", "htdocs", "Webstart");
    }

    @Override
    protected String getAppFileConfigFileName(Application appType) {
        if (Application.Waitermate.equals((Object)appType)) {
            return WAITER;
        }
        if (Application.Officemate.equals((Object)appType)) {
            return OFFICE;
        }
        if (Application.Servermate.equals((Object)appType)) {
            return SERVER;
        }
        if (Application.TouchPrepXPress.equals((Object)appType)) {
            return KTS;
        }
        return "";
    }
}

