/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;

@Entity
@Table(name="config_exp_feature")
public class ExperimentalFeature
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String name;
    private String value;
    private transient Object cache;

    public static ExperimentalFeature find(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property cannot be null or empty for a experimental feature.");
        }
        ExperimentalFeature feature = PersistenceManager.getObject(ExperimentalFeature.class, Query.select(ExperimentalFeature.class).equals(ExperimentalFeature.Properties.NAME, name).toString(), null);
        return feature;
    }

    @Deprecated
    public ExperimentalFeature() {
    }

    public ExperimentalFeature(String exName, String exValue) {
        this.name = exName;
        this.value = exValue;
    }

    @Transient
    public Object getCache() {
        return this.cache;
    }

    public void setCache(Object value) {
        this.cache = value;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return this.name;
    }

    protected void setName(String value) {
        this.name = value;
    }

    @Column(name="value", nullable=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getStringValue(String defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        return this.value;
    }

    public Integer getIntValue(Integer defaultValue) {
        try {
            if (this.value != null) {
                return Integer.valueOf(this.value);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to an integer, returning null.");
        }
        return defaultValue;
    }

    public Double getDoubleValue(Double defaultValue) {
        try {
            if (this.value != null) {
                return Double.valueOf(this.value);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to a double, returning null.");
        }
        return defaultValue;
    }

    public Boolean getBooleanValue(Boolean defaultValue) {
        if (this.value != null) {
            return Boolean.valueOf(this.value);
        }
        return defaultValue;
    }

    public Date getDateValue(Date defaultValue) {
        try {
            Long millis;
            if (this.value != null && (millis = Long.valueOf(this.value)) != null) {
                return new Date(millis);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to a number, returning null.");
        }
        return defaultValue;
    }

    public <T extends PersistentObject> T getAsObject(Class<T> clazz, T defaultObject) {
        try {
            Long id;
            if (this.value != null && (id = Long.valueOf(this.value)) != null) {
                return PersistenceManager.getByID(id, clazz);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to an object of type " + clazz + ", returning null.");
        }
        return defaultObject;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property VALUE;
    }
}

