/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.units.UnitScales;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;
import stockmate.database.interfaces.stock.MeasureUnitI;

@Entity
@Table(name="config_measure_unit")
@AccessType(value="property")
public class MeasureUnit
extends PersistentDisplayableObject
implements Saveable,
Serializable,
MeasureUnitI {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private UnitScales unitScale;
    private double value;
    private String suffix;

    public MeasureUnit() {
    }

    public MeasureUnit(UnitScales scale, double value, String name, String suffix) {
        this.unitScale = scale;
        this.value = value;
        this.setLabel(name);
        this.suffix = suffix;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="scale")
    public UnitScales getUnitScale() {
        return this.unitScale;
    }

    public void setUnitScale(UnitScales scale) {
        this.unitScale = scale;
    }

    @Column(name="value")
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Column(name="suffix")
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Transient
    public String getName() {
        return this.getLabel();
    }

    @Transient
    public String getScale() {
        return this.getUnitScale().name();
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof MeasureUnit) {
            MeasureUnit m = (MeasureUnit)o;
            return this.getLabel().equals(m.getName());
        }
        return false;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<UnitScales> UNIT_SCALE;
        public PropertiedObject.Property<Double> VALUE;
        public PropertiedObject.Property<String> SUFFIX;
    }
}

