/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.MathsUtils;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_measure_unit_container")
@AccessType(value="property")
public class MeasureUnitContainer
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private Reference<MeasureContainer> measureContainer;
    private Reference<MeasureUnit> measureUnit;
    private double quantityPerContainer;
    private transient String displayName;

    public MeasureUnitContainer() {
        this.measureContainer = this.createReference(MeasureUnitContainer.Properties.MEASURE_CONTAINER);
        this.measureUnit = this.createReference(MeasureUnitContainer.Properties.MEASURE_UNIT);
        this.quantityPerContainer = 1.0;
    }

    public MeasureUnitContainer(MeasureUnit unit) {
        this(unit, null, 1.0);
    }

    public MeasureUnitContainer(MeasureUnit unit, MeasureContainer container, double quantityPerContainer) {
        this.measureContainer = this.createReference(MeasureUnitContainer.Properties.MEASURE_CONTAINER);
        this.measureUnit = this.createReference(MeasureUnitContainer.Properties.MEASURE_UNIT);
        this.quantityPerContainer = 1.0;
        this.setMeasureUnit(unit);
        this.setMeasureContainer(container);
        this.setQuantityPerContainer(quantityPerContainer);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Column(name="qty_per_container")
    public double getQuantityPerContainer() {
        return this.quantityPerContainer;
    }

    public void setQuantityPerContainer(double value) {
        if (this.quantityPerContainer <= 0.0) {
            this.quantityPerContainer = 1.0;
        }
        this.quantityPerContainer = value;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_measure_container")
    public MeasureContainer getMeasureContainer() {
        return this.measureContainer.get();
    }

    public void setMeasureContainer(MeasureContainer measureContainer) {
        this.measureContainer.set(measureContainer);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_measure_unit")
    public MeasureUnit getMeasureUnit() {
        return this.measureUnit.get();
    }

    public void setMeasureUnit(MeasureUnit measureUnit) {
        this.measureUnit.set(measureUnit);
    }

    @Transient
    public String getDisplayName() {
        if (this.displayName == null) {
            if (this.measureUnit.isNull()) {
                return super.toString();
            }
            StringBuilder SB = new StringBuilder();
            if (!this.measureContainer.isNull() && !"<none>".equals(this.measureContainer.get().getLabel())) {
                SB.append(this.measureContainer.get().getLabel());
            }
            SB.append(" ").append(MathsUtils.neatenDouble(this.quantityPerContainer, 3));
            SB.append(this.measureUnit.get().getSuffix());
            this.displayName = SB.toString();
        }
        return this.displayName;
    }

    @Transient
    public double getMultiplier() {
        return this.measureUnit.get().getValue() * this.getQuantityPerContainer();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<MeasureContainer> MEASURE_CONTAINER;
        public PropertiedObject.Property<MeasureUnit> MEASURE_UNIT;
        public PropertiedObject.Property<Double> QUANTITY_PER_CONTAINER;
        public PersistentObject.DerivedProperty<String> DISPLAY_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)MeasureUnitContainer.class), "displayName");
    }
}

