/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.database.DatabaseConnection;
import au.com.ordermate.units.UnitScales;
import au.com.ordermate.util.MathsUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.OldSkoolMeasureUnit;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class MeasureUnitHelper
implements Serializable {
    public static final String UNIT = "unit";
    public static final String UNITS = "units";
    public static final String EACH = "each";
    public static final String GRAMS = "grams";
    public static final String KILOGRAMS = "kilograms";
    public static final String MILLILITRES = "millilitres";
    public static final String LITRES = "litres";
    private static Hashtable<String, MeasureUnit> registeredUnits;
    private static List<MeasureUnit> orderedUnits;
    private static List<MeasureContainer> containers;

    private MeasureUnitHelper() {
    }

    public static void initialiseMeasureUnits() {
        registeredUnits.clear();
        orderedUnits.clear();
        List<MeasureUnit> units = PersistenceManager.getObjectList(MeasureUnit.class, Query.select(MeasureUnit.class).active(MeasureUnit.class).toString());
        for (MeasureUnit unit : units) {
            MeasureUnitHelper.registerMeasureUnit(unit);
        }
        MeasureUnitHelper.ensureBasicSet();
    }

    public static void ensureBasicSet() {
        MeasureUnitHelper.ensureExists(UnitScales.Units, 1.0, UNIT, "");
        MeasureUnitHelper.ensureExists(UnitScales.Units, 1.0, UNITS, "");
        MeasureUnitHelper.ensureExists(UnitScales.Units, 1.0, EACH, " ea.");
        MeasureUnitHelper.ensureExists(UnitScales.Weight, 1.0, GRAMS, " g");
        MeasureUnitHelper.ensureExists(UnitScales.Weight, 1000.0, KILOGRAMS, " kg");
        MeasureUnitHelper.ensureExists(UnitScales.Volume, 1.0, MILLILITRES, " mL");
        MeasureUnitHelper.ensureExists(UnitScales.Volume, 1000.0, LITRES, " L");
    }

    private static void ensureExists(UnitScales scale, double value, String name, String suffix) {
        MeasureUnit unit = MeasureUnitHelper.getMeasureUnitForName(name);
        if (unit == null) {
            unit = new MeasureUnit(scale, value, name, suffix);
            MeasureUnitHelper.registerMeasureUnit(unit);
        }
    }

    private static void registerMeasureUnit(MeasureUnit unit) {
        String name = unit.getName().trim().toLowerCase();
        if (registeredUnits.contains(name)) {
            throw new IllegalArgumentException("Already registered :" + unit);
        }
        registeredUnits.put(name, unit);
        orderedUnits.add(unit);
    }

    public static MeasureUnit getMeasureUnit(String name) {
        MeasureUnit unit = null;
        if (name != null) {
            unit = registeredUnits.get(name.trim().toLowerCase());
        }
        if (unit == null) {
            OrderMateLog.LOG.info("Couldn't find unit: " + name);
            unit = MeasureUnitHelper.getMeasureUnitForName(UNIT);
        }
        return unit;
    }

    public static MeasureUnit getMeasureUnitForName(String name) {
        MeasureUnit unit = null;
        if (name != null) {
            unit = registeredUnits.get(name.trim().toLowerCase());
        }
        return unit;
    }

    public static List<MeasureUnit> getOrderedRegisteredMeasureUnits() {
        return orderedUnits;
    }

    public static Collection getAllRegisteredMeasureUnits() {
        return registeredUnits.values();
    }

    public static MeasureUnit createMeasureUnit(String scale, double value, String name, String suffix) throws SQLException {
        String query = "INSERT INTO config_measure_unit VALUES(NULL, 'ACTIVE', '" + scale + "', " + value + ", '" + name + "', '" + suffix + "', '0')";
        DatabaseConnection.getDBConnectionInterface().executeInsert(query);
        MeasureUnitHelper.initialiseMeasureUnits();
        MeasureUnit measureUnit = MeasureUnitHelper.getMeasureUnitForName(name);
        return measureUnit;
    }

    @Deprecated
    public static MeasureUnit createOuterMeasureUnit(String outerName, double outerMultiplier, double rawQuantityPerUnit) {
        return new MeasureUnit(UnitScales.Units, outerMultiplier * rawQuantityPerUnit, outerName, outerName);
    }

    public static List<MeasureContainer> getOrderedContainers() {
        if (containers == null) {
            containers = PersistenceManager.getObjectList(MeasureContainer.class, Query.select(MeasureContainer.class).active(MeasureContainer.class).orderBy(MeasureContainer.Properties.LABEL).toString());
        }
        return containers;
    }

    public static MeasureContainer getContainerForName(String name) {
        return MeasureUnitHelper.getContainerForName(name, false);
    }

    public static MeasureContainer getContainerForName(String name, boolean createIfRequired) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        MeasureContainer container = PersistenceManager.getObject(MeasureContainer.class, Query.select(MeasureContainer.class).equals(MeasureContainer.Properties.LABEL, name).toString(), null);
        if (container == null && createIfRequired) {
            container = new MeasureContainer(name);
            container.save();
        }
        return container;
    }

    public static String stringify(double number, MeasureContainer outerContainer) {
        String numberStr = Math.floor(number) == number ? Integer.toString((int)number) : String.valueOf(MathsUtils.roundDouble(number, 0.001));
        if (outerContainer != null && !"<none>".equals(outerContainer.getLabel())) {
            return numberStr + " " + outerContainer.getLabel();
        }
        return numberStr;
    }

    public static String stringify(double number, MeasureContainer outerContainer, MeasureUnit unit) {
        StringBuilder SB = new StringBuilder();
        String numberStr = Math.floor(number) == number ? Integer.toString((int)number) : String.valueOf(MathsUtils.roundDouble(number, 0.001));
        SB.append(numberStr);
        if (unit != null) {
            SB.append(unit.getSuffix());
        }
        if (outerContainer != null && !"<none>".equals(outerContainer.getLabel())) {
            SB.append(" ").append(outerContainer.getLabel());
        }
        return SB.toString();
    }

    public static double wrangleQtyPerUnit(String oldString) {
        if (oldString == null || oldString.isEmpty()) {
            return 1.0;
        }
        int NOT_FOUND = -1;
        String ALLOWED_CHARS = ",.";
        int first = -1;
        int last = oldString.length();
        for (int i = 0; i < oldString.length(); ++i) {
            if (Character.isDigit(oldString.charAt(i)) && first == -1) {
                first = i;
                continue;
            }
            if (first == -1 || Character.isDigit(oldString.charAt(i)) || ",.".indexOf(oldString.charAt(i)) != -1) continue;
            last = i;
            break;
        }
        if (first != -1 && last != first) {
            return Double.parseDouble(oldString.substring(first, last).replace(",", ""));
        }
        return 1.0;
    }

    public static MeasureUnit wrangleMeasureUnit(String oldString) {
        if (oldString == null || oldString.isEmpty()) {
            return MeasureUnitHelper.getMeasureUnit(UNIT);
        }
        boolean hasDigit = false;
        int index = 0;
        if (!Character.isDigit(oldString.charAt(0))) {
            String firstPart;
            MeasureUnit unit;
            int i = 0;
            while (i < oldString.length()) {
                if (Character.isDigit(oldString.charAt(i))) {
                    hasDigit = true;
                    break;
                }
                index = i++;
            }
            if ((unit = MeasureUnitHelper.getMeasureUnitForName(firstPart = oldString.substring(0, index + 1).trim())) != null) {
                return unit;
            }
        }
        index = oldString.length();
        int i = oldString.length() - 1;
        while (i > 0) {
            if (Character.isDigit(oldString.charAt(i))) {
                hasDigit = true;
                break;
            }
            index = i--;
        }
        if (index <= oldString.length() - 1) {
            String lastBit = oldString.substring(index).trim();
            for (MeasureUnit nextUnit : orderedUnits) {
                if (!lastBit.equalsIgnoreCase(nextUnit.getSuffix().trim())) continue;
                return nextUnit;
            }
        }
        if (!hasDigit) {
            return MeasureUnitHelper.getMeasureUnit(UNIT);
        }
        return null;
    }

    public static String wrangleMeasureContainer(String oldString) {
        if (oldString == null || oldString.isEmpty()) {
            return null;
        }
        int index = 0;
        for (int i = 0; i < oldString.length() && !Character.isDigit(oldString.charAt(i)); ++i) {
            index = i + 1;
        }
        if (index == 0) {
            return null;
        }
        String firstPart = oldString.substring(0, index).trim();
        if (MeasureUnitHelper.getMeasureUnitForName(firstPart) != null) {
            return null;
        }
        return firstPart;
    }

    public static MeasureUnitI convertToOldSkoolMeasure(MeasureUnit unit, String container, double qtyPerUnit) {
        StringBuilder SB = new StringBuilder();
        if (container != null && !container.trim().isEmpty()) {
            SB.append(container);
            if (qtyPerUnit * unit.getValue() != 1.0) {
                SB.append(" ").append(NumberFormat.getNumberInstance().format(qtyPerUnit)).append(unit.getSuffix());
            }
        } else {
            container = null;
            SB.append(unit.getLabel());
        }
        return new OldSkoolMeasureUnit(unit, SB.toString(), qtyPerUnit, container == null ? unit.getSuffix() : container);
    }

    static {
        orderedUnits = new ArrayList<MeasureUnit>();
        registeredUnits = new Hashtable();
    }
}

