/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config;

import au.com.ordermate.util.Assert;
import java.math.BigDecimal;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import stockmate.database.interfaces.stock.MeasureUnitI;
import stockmate.database.interfaces.stock.QuantityI;

public class Quantity
extends Number
implements Comparable,
QuantityI {
    public static final int DECIMAL_PLACES = 3;
    private final double rawAmount;
    private final MeasureUnitI measure;
    private final double qtyPerContainer;
    private final MeasureContainer container;
    private final double multiplier;
    private transient String toStringValue;

    public static final Quantity ZERO() {
        return new Quantity(0.0);
    }

    public Quantity(double amount) {
        this(MeasureUnitHelper.getMeasureUnitForName("units"), amount, true);
    }

    public Quantity(BigDecimal amount) {
        this((MeasureUnitI)MeasureUnitHelper.getMeasureUnitForName("units"), amount);
    }

    public Quantity(MeasureUnitI unit, BigDecimal amount) {
        this(unit, amount.doubleValue(), true);
    }

    public Quantity(Quantity qty) {
        this(qty.measure, qty.rawAmount, true);
    }

    public Quantity(Quantity qty, double RawAmount) {
        this(qty.measure, qty.qtyPerContainer, qty.container, RawAmount, true);
    }

    public Quantity(MeasureUnitI measureUnit, double rawQtyAmount) {
        this(measureUnit, rawQtyAmount, true);
    }

    public Quantity(MeasureUnitI measureUnit, double amount, boolean isRawAmt) {
        this(measureUnit, 1.0, null, amount, isRawAmt);
    }

    public Quantity(MeasureUnitContainer unitContainer, double amount, boolean isRawAmt) {
        this(unitContainer.getMeasureUnit(), unitContainer.getQuantityPerContainer(), unitContainer.getMeasureContainer(), amount, isRawAmt);
    }

    public Quantity(MeasureUnitI measureUnit, double qtyPerContainer, MeasureContainer container, double amount, boolean isRawAmt) {
        this.measure = measureUnit;
        this.qtyPerContainer = qtyPerContainer;
        this.container = container;
        if (this.measure == null) {
            throw new IllegalArgumentException("Cannot have a null measure unit.");
        }
        this.multiplier = this.measure.getValue() * qtyPerContainer;
        this.rawAmount = isRawAmt ? amount : amount * this.multiplier;
    }

    public Quantity getAsMeasure(MeasureUnitI otherMeasure) {
        if (!this.isConvertibleTo(otherMeasure)) {
            throw new IllegalArgumentException("Other measure unit :" + otherMeasure + " is not convertible to this : " + this);
        }
        Assert.isEqual(this.measure.getScale(), otherMeasure.getScale(), "Cannot convert " + this.measure + " quantity to " + otherMeasure + ": scales are different");
        return new Quantity(otherMeasure, this.rawAmount, true);
    }

    public boolean isConvertibleTo(MeasureUnitI otherUnit) {
        return this.measure.getScale().equals(otherUnit.getScale());
    }

    public double getRawValue() {
        return this.rawAmount;
    }

    @Override
    public double doubleValue() {
        return this.rawAmount / this.multiplier;
    }

    public double doubleValue(int decPlaces) {
        double amount = this.rawAmount / this.multiplier;
        double exp = Math.pow(10.0, decPlaces);
        amount *= exp;
        amount = Math.floor(amount);
        return amount /= exp;
    }

    @Override
    public float floatValue() {
        return (float)(this.rawAmount / this.multiplier);
    }

    @Override
    public int intValue() {
        return (int)(this.rawAmount / this.multiplier);
    }

    @Override
    public long longValue() {
        return (long)(this.rawAmount / this.multiplier);
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.doubleValue());
    }

    public String toString() {
        if (this.toStringValue == null) {
            double val = this.doubleValue();
            String numberStr = Math.floor(val) == val ? Integer.toString((int)val) : String.valueOf(this.doubleValue(3));
            StringBuilder SB = new StringBuilder(numberStr);
            String suffix = this.getSuffix();
            if (!suffix.isEmpty()) {
                SB.append(" ").append(this.getSuffix());
            }
            this.toStringValue = SB.toString();
        }
        return this.toStringValue;
    }

    public String getSuffix() {
        StringBuilder SB = new StringBuilder();
        if (this.container != null) {
            if (!"<none>".equals(this.container.getLabel())) {
                SB.append(this.container.getLabel()).append(" ");
            }
            if (!"Units".equals(this.measure.getScale()) || this.measure.getValue() != 1.0 || this.qtyPerContainer != 1.0) {
                SB.append((int)this.qtyPerContainer);
            }
            SB.append(this.measure.getSuffix().trim());
        } else if (this.measure.getSuffix() != null && this.measure.getSuffix().trim().length() != 0) {
            SB.append(this.measure.getSuffix().trim());
        }
        return SB.toString();
    }

    public MeasureUnitI getMeasureUnit() {
        return this.measure;
    }

    public MeasureContainer getMeasureContainer() {
        return this.container;
    }

    public double getQtyPerContainer() {
        return this.qtyPerContainer;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.rawAmount) ^ Double.doubleToLongBits(this.rawAmount) >>> 32);
        hash = 97 * hash + (this.measure != null ? this.measure.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof Quantity) {
            Quantity q = (Quantity)o;
            return q.measure.getScale().equals(this.measure.getScale()) && Math.abs(q.rawAmount - this.rawAmount) < 1.0E-7;
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof Quantity) {
            Quantity q = (Quantity)o;
            return this.rawAmount < q.rawAmount ? -1 : (this.rawAmount > q.rawAmount ? 1 : 0);
        }
        return 0;
    }

    public static Quantity parseQuantity(String quantity) {
        if (quantity.trim().length() == 0) {
            return new Quantity(0.0);
        }
        int separatorIndex = quantity.indexOf(32);
        if (separatorIndex == -1) {
            separatorIndex = quantity.indexOf(46);
        }
        String quantityValue = quantity;
        String quantityMeasure = null;
        if (separatorIndex > 0) {
            quantityValue = quantity.substring(0, separatorIndex);
            if (separatorIndex < quantity.length()) {
                quantityMeasure = quantity.substring(separatorIndex + 1);
            }
        }
        double value = Double.parseDouble(quantityValue);
        if (quantityMeasure != null && quantityMeasure.trim().length() > 0) {
            MeasureUnit measureUnit = MeasureUnitHelper.getMeasureUnit(quantityMeasure);
            return new Quantity((MeasureUnitI)measureUnit, value);
        }
        return new Quantity(value);
    }

    public static Quantity parseQuantity(MeasureUnitI defaultUnit, String quantity) {
        if (quantity.trim().length() == 0) {
            return new Quantity(defaultUnit, 0.0);
        }
        int separatorIndex = quantity.indexOf(32);
        String quantityValue = quantity;
        String quantityMeasure = null;
        if (separatorIndex > 0) {
            quantityValue = quantity.substring(0, separatorIndex);
            if (separatorIndex < quantity.length()) {
                quantityMeasure = quantity.substring(separatorIndex + 1);
            }
        }
        double value = Double.parseDouble(quantityValue);
        MeasureUnitI measureUnit = null;
        if (quantityMeasure != null && quantityMeasure.trim().length() > 0) {
            measureUnit = MeasureUnitHelper.getMeasureUnitForName(quantityMeasure);
        }
        if (measureUnit == null) {
            measureUnit = defaultUnit;
        }
        return new Quantity(measureUnit, value, false);
    }

    public Quantity add(QuantityI toAdd) {
        Quantity qty = (Quantity)toAdd;
        return new Quantity(this.measure, this.rawAmount + qty.rawAmount);
    }

    public Quantity subtract(Quantity removedQty) {
        return new Quantity(this.measure, this.rawAmount - removedQty.rawAmount);
    }

    public String getAmountString() {
        double val = this.doubleValue();
        if (Math.floor(val) == val) {
            return Integer.toString((int)val);
        }
        return String.valueOf(this.doubleValue(3));
    }

    public static boolean isZero(Quantity quantity) {
        if (quantity == null) {
            throw new IllegalArgumentException("quantity cannot be null");
        }
        return quantity.isZero();
    }

    public boolean isZero() {
        return Math.abs(this.getRawValue()) < 1.0E-8;
    }

    public Quantity multiply(double product) {
        return new Quantity(this.measure, this.rawAmount * product);
    }

    public boolean lessThan(Quantity other) {
        return this.rawAmount < other.rawAmount;
    }

    public boolean greaterThan(Quantity other) {
        return this.rawAmount > other.rawAmount;
    }

    public Quantity abs() {
        return new Quantity(this.measure, Math.abs(this.rawAmount));
    }

    public double divide(Quantity quantityPerUnit) {
        return this.getRawValue() / quantityPerUnit.getRawValue();
    }
}

