/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.custompermission;

import au.com.ordermate.guicore.task.GUIStateI;
import java.util.List;
import ordermate.database.config.custompermission.CustomPermission;
import ordermate.database.config.custompermission.CustomPermissionSearcher;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;

public class CustomPermissionHelper {
    public static final String CAT_OM_STATE = "Officemate State";
    public static final String CAT_CUSTOM_REPORT = "Custom Report";
    public static final String STATEKEY_PREFIX = "_DYNAMIC_";

    public static CustomPermission getPermission(String category, String key) {
        CustomPermissionSearcher searcher = new CustomPermissionSearcher();
        searcher.getCategoryFilter().setSearchValue(category);
        searcher.getPermissionKeyFilter().setSearchValue(key);
        List results = searcher.search();
        return results.isEmpty() ? null : (CustomPermission)results.get(0);
    }

    public static List<CustomPermission> getPermissions(String category) {
        CustomPermissionSearcher searcher = new CustomPermissionSearcher();
        searcher.getCategoryFilter().setSearchValue(category);
        return searcher.search();
    }

    public static boolean isPermitted(String category, String key, PermissionGroup group, boolean defaultValue) {
        List<CustomPermission> permissions = CustomPermissionHelper.getPermissions(category);
        if (permissions.isEmpty()) {
            return defaultValue;
        }
        for (CustomPermission permission : permissions) {
            if (!key.equals(permission.getPermissionKey()) || group.getLevel() < permission.getGroup().getLevel()) continue;
            return true;
        }
        return false;
    }

    public static String getAccessLevel(GUIStateI theState, User currentUser) {
        if (currentUser == null || theState == null) {
            return null;
        }
        return CustomPermissionHelper.getAccessLevelViaKey(theState.getStateKey(), currentUser);
    }

    public static String getAccessLevelViaKey(String blueprintKey, User currentUser) {
        CustomPermission customReportPermission;
        String accessLevel;
        String key = blueprintKey;
        if (key.startsWith(STATEKEY_PREFIX)) {
            key = key.substring(key.lastIndexOf("_") + 1);
        }
        if ((accessLevel = CustomPermissionHelper.getAccessLevelForPermission(customReportPermission = CustomPermissionHelper.getPermission(CAT_CUSTOM_REPORT, key), currentUser)) != null) {
            return accessLevel;
        }
        CustomPermission customStatePermission = CustomPermissionHelper.getPermission(CAT_OM_STATE, key);
        return CustomPermissionHelper.getAccessLevelForPermission(customStatePermission, currentUser);
    }

    private static String getAccessLevelForPermission(CustomPermission permission, User user) {
        if (permission != null && permission.getGroup() != null) {
            if (permission.getGroup().getLevel() > user.getPermissionGroup().getLevel()) {
                return "HIDDEN";
            }
            return "ENABLED";
        }
        return null;
    }
}

