/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.location;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_sales_location")
@AccessType(value="property")
public class SalesLocation
extends PersistentDisplayableObject
implements Saveable {
    public static final Props Properties = new Props();
    private static SalesLocation cachedDefaultLocation;
    private SystemState systemState = SystemState.ACTIVE_STATE;

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    protected SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static List<SalesLocation> getSalesLocations() {
        ObjectQuery query = Query.select(SalesLocation.class).active(SalesLocation.class).orderBy(SalesLocation.Properties.LABEL);
        return PersistenceManager.getObjectList(SalesLocation.class, query.toString(), null);
    }

    public static SalesLocation getDefaultSalesLocation() {
        if (cachedDefaultLocation == null) {
            List<SalesLocation> salesLocations = SalesLocation.getSalesLocations();
            if (salesLocations.isEmpty()) {
                OrderMate.LOG.error("There should be at least one sales location in the system!");
            } else {
                cachedDefaultLocation = SalesLocation.getSalesLocations().get(0);
            }
        }
        return cachedDefaultLocation;
    }

    public static SalesLocation getSalesLocationForName(String name) {
        return PersistenceManager.getObject(SalesLocation.class, Query.select(SalesLocation.class).active(SalesLocation.class).equals(SalesLocation.Properties.LABEL, name).toString());
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
    }
}

