/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.report;

import au.com.ordermate.oquery.search.control.SearchFilterControl;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.config.report.ReportConfigFilter;
import ordermate.database.config.report.ReportConfigRowAction;
import ordermate.database.config.report.ReportProperty;

@Entity
@Table(name="config_report")
public class ReportConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private String type;
    private PersistentWriteableList<ReportConfigFilter> filters;
    private PersistentWriteableList<ReportConfigRowAction> actions;
    private PersistentWriteableList<ReportProperty> reportProperties;
    private String systemState;

    @Deprecated
    public ReportConfig() {
        this.filters = this.createWriteableList(ReportConfig.Properties.FILTERS);
        this.actions = this.createWriteableList(ReportConfig.Properties.ACTIONS);
        this.reportProperties = this.createWriteableList(ReportConfig.Properties.REPORT_PROPERTIES);
        this.systemState = "ACTIVE";
    }

    public ReportConfig(String yourType, String yourLabel) {
        this.filters = this.createWriteableList(ReportConfig.Properties.FILTERS);
        this.actions = this.createWriteableList(ReportConfig.Properties.ACTIONS);
        this.reportProperties = this.createWriteableList(ReportConfig.Properties.REPORT_PROPERTIES);
        this.systemState = "ACTIVE";
        if (yourType == null) {
            throw new IllegalArgumentException("Cannot have a reportConfig with a null type");
        }
        if (yourLabel == null) {
            throw new IllegalArgumentException("Cannot have a reportConfig with a null label");
        }
        this.type = yourType;
        this.label = yourLabel;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="report_type")
    public String getType() {
        return this.type;
    }

    protected void setType(String value) {
        this.type = value;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(String value) {
        this.systemState = value;
    }

    @OneToMany(mappedBy="reportConfig", targetEntity=ReportConfigFilter.class)
    public List<ReportConfigFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ReportConfigFilter> yourFilters) {
        this.filters.set(yourFilters);
    }

    @OneToMany(mappedBy="reportConfig", targetEntity=ReportProperty.class)
    public List<ReportProperty> getReportProperties() {
        return this.reportProperties.getUnmodifiable();
    }

    protected void setReportProperties(List<ReportProperty> yourReportProperties) {
        this.filters.set(yourReportProperties);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.filters.saveChild();
        this.reportProperties.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.label == null ? "New Report Config" : this.label;
    }

    public ReportConfigFilter getFilter(String string) {
        for (ReportConfigFilter nextFilter : this.filters) {
            if (!string.equals(nextFilter.getFilterName())) continue;
            return nextFilter;
        }
        return null;
    }

    public ReportProperty getReportProperty(String string) {
        if (!this.reportProperties.isEmpty()) {
            for (ReportProperty nextProp : this.reportProperties) {
                if (!string.equals(nextProp.getProp())) continue;
                return nextProp;
            }
        }
        ReportProperty property = ReportProperty.makeConfigReportProperty(string, this);
        this.reportProperties.add(property);
        return property;
    }

    public void synchronizeFilters(List<SearchFilterControl> reportFilterControls) {
        HashMap<String, ReportConfigFilter> filterMap = new HashMap<String, ReportConfigFilter>();
        for (ReportConfigFilter filter : this.filters) {
            filterMap.put(filter.getFilterName(), filter);
        }
        HashSet<SearchFilterControl> controlsToAdd = new HashSet<SearchFilterControl>();
        for (SearchFilterControl searchFilterControl : reportFilterControls) {
            if (filterMap.containsKey(searchFilterControl.getName())) {
                filterMap.remove(searchFilterControl.getName());
                continue;
            }
            controlsToAdd.add(searchFilterControl);
        }
        this.filters.removeAll(filterMap.values());
        for (SearchFilterControl<Object> searchFilterControl : controlsToAdd) {
            ReportConfigFilter filter = new ReportConfigFilter(this, searchFilterControl.getName());
            this.filters.add(filter);
        }
    }

    public void synchronizeReportProperties(List<ReportProperty> values) {
        HashMap<String, ReportProperty> propMap = new HashMap<String, ReportProperty>();
        for (ReportProperty property : this.reportProperties) {
            propMap.put(property.getProp(), property);
        }
        HashSet<ReportProperty> toAdd = new HashSet<ReportProperty>();
        for (ReportProperty nextProp : values) {
            if (propMap.containsKey(nextProp.getProp())) {
                propMap.remove(nextProp.getProp());
                continue;
            }
            toAdd.add(nextProp);
        }
        this.reportProperties.removeAll(propMap.values());
        for (ReportProperty nextProp : toAdd) {
            this.reportProperties.add(nextProp);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> TYPE;
        public PropertiedObject.Property<ReportConfigFilter> FILTERS;
        public PropertiedObject.Property<ReportConfigRowAction> ACTIONS;
        public PropertiedObject.Property<ReportProperty> REPORT_PROPERTIES;
        public PropertiedObject.Property<String> SYSTEM_STATE;
    }
}

