/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.report;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.config.report.ReportConfig;

@Entity
@Table(name="config_report_filter")
public class ReportConfigFilter
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String filterName;
    private String searchValue;
    private Reference<ReportConfig> reportConfig;

    @Deprecated
    public ReportConfigFilter() {
        this.reportConfig = this.createReference(ReportConfigFilter.Properties.REPORT_CONFIG);
    }

    public ReportConfigFilter(ReportConfig yourConfig, String theFilter) {
        this.reportConfig = this.createReference(ReportConfigFilter.Properties.REPORT_CONFIG);
        if (theFilter == null) {
            throw new IllegalArgumentException("Cannot have a filter of no name");
        }
        this.setReportConfig(yourConfig);
        this.filterName = theFilter;
        this.searchValue = null;
    }

    @Column(name="filter_label")
    public String getFilterName() {
        return this.filterName;
    }

    protected void setFilterName(String value) {
        this.filterName = value;
    }

    @Column(name="search_value")
    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String value) {
        this.searchValue = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_report")
    public ReportConfig getReportConfig() {
        return this.reportConfig.get();
    }

    protected void setReportConfig(ReportConfig value) {
        this.reportConfig.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public String toString() {
        return this.getFilterName() == null ? "<No Name>" : this.getFilterName();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> FILTER_NAME;
        public PropertiedObject.Property<String> SEARCH_VALUE;
        public PropertiedObject.Property<ReportConfig> REPORT_CONFIG;
    }
}

