/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.report;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.reports.ReportOutput;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.users.User;

public class ReportConfigSchedule
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private String email = "";
    private String users = "";
    private String cronSchedule = "";
    private Reference<ReportConfig> reportConfig;
    private ReportOutput reportOutput;
    private transient List<User> userList;

    @Deprecated
    public ReportConfigSchedule() {
        this.reportConfig = this.createReference(ReportConfigSchedule.Properties.REPORT_CONFIG);
        this.reportOutput = ReportOutput.PDF;
    }

    public ReportConfigSchedule(ReportConfig config) {
        this.reportConfig = this.createReference(ReportConfigSchedule.Properties.REPORT_CONFIG);
        this.reportOutput = ReportOutput.PDF;
        this.email = "";
        this.cronSchedule = "";
        this.setReportConfig(config);
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        this.systemState = value;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public void setCronSchedule(String value) {
        this.cronSchedule = value;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig.get();
    }

    protected void setReportConfig(ReportConfig value) {
        this.reportConfig.set(value);
    }

    public List<String> getEmailList() {
        return StringUtils.splitToList(this.getEmail(), ",");
    }

    public void setEmailList(List<String> values) {
        this.email = values == null || values.isEmpty() ? null : StringUtils.mergeWithSeparator(values, ",");
    }

    public List<User> getUserList() {
        if (this.userList == null) {
            ArrayList<User> resolvedUsers = new ArrayList<User>();
            for (String nextId : StringUtils.splitToList(this.users, ",")) {
                if (nextId.isEmpty()) continue;
                try {
                    User user = PersistenceManager.getByID(Long.parseLong(nextId), User.class);
                    if (user != null) {
                        resolvedUsers.add(user);
                        continue;
                    }
                    OrderMate.LOG.warn("Cannot find user for id " + nextId);
                }
                catch (NumberFormatException ex) {
                    OrderMate.LOG.warn("Cannot parse as long id " + nextId, (Throwable)ex);
                }
            }
            this.userList = resolvedUsers;
        }
        return this.userList;
    }

    public void setUserList(List<User> values) {
        this.userList = values == null ? new ArrayList<User>() : new ArrayList<User>(values);
        ArrayList<String> ids = new ArrayList<String>();
        for (User user : this.userList) {
            ids.add(user.getID().toString());
        }
        this.users = StringUtils.mergeWithSeparator(ids, ",");
    }

    public String getUsers() {
        return this.users;
    }

    protected void setUsers(String value) {
        this.users = value;
    }

    public ReportOutput getReportOutput() {
        return this.reportOutput;
    }

    public void setReportOutput(ReportOutput output) {
        if (output != null) {
            this.reportOutput = output;
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = SystemState.INACTIVE_STATE;
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<ReportConfig> REPORT_CONFIG;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<String> CRON_SCHEDULE;
        public PropertiedObject.Property<String> EMAIL;
        public PropertiedObject.Property<String> USERS;
        public PropertiedObject.Property<ReportOutput> REPORT_OUTPUT;
        public PersistentObject.DerivedProperty<String> EMAIL_LIST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ReportConfigSchedule.class), "emailList");
        public PersistentObject.DerivedProperty<User> USER_LIST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ReportConfigSchedule.class), "userList");
    }
}

