/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.report;

import au.com.ordermate.util.StringUtils;
import java.util.Calendar;
import java.util.List;
import ordermate.database.misc.SystemProperty;
import ordermate.scheduler.RecurrenceParser;

public class ReportConfigScheduleHelper {
    public static String amendCronHourToAfterRollover(String cron) {
        List<String> parts = StringUtils.splitToList(cron, " ");
        if (parts.size() < 7) {
            return cron;
        }
        int hour = Integer.parseInt(parts.get(2));
        Calendar rolloverTime = Calendar.getInstance();
        rolloverTime.setTime(SystemProperty.getInstance().getChangeDayTime());
        rolloverTime.roll(11, true);
        hour = rolloverTime.get(11);
        parts.set(2, String.valueOf(hour));
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part).append(" ");
        }
        return sb.toString().trim();
    }

    public static enum ReportScheduleOptions {
        DAILY("Daily, when the new trading day begins", RecurrenceParser.CronCheatCode.TRADING_DAY.getValue()),
        WEEKLY("Weekly, every Monday", "0 0 5 ? * MON *"),
        MONTHLY("Monthly, on the 1st", "0 0 5 1 1/1 ? *"),
        YEARLY("Yearly, on the first day of the year", "0 0 5 1 1 ? *"),
        YEARLY_FINANCIAL("Yearly, on the first day of the financial year", "0 0 5 1 7 ? *"),
        AUTO_SEND_ON_COMPLETION("Automatically send on task completion", RecurrenceParser.CronCheatCode.AUTO_SEND.getValue());

        private String name;
        private String value;

        private ReportScheduleOptions(String aName, String aValue) {
            this.name = aName;
            this.value = aValue;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

