/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.report;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportGroup;

@Entity
@Table(name="config_report_property")
public class ReportProperty
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private ReportGroup reportGroup;
    private String prop;
    private String value;
    private Reference<ReportConfig> reportConfig;

    @Deprecated
    public ReportProperty() {
        this.reportConfig = this.createReference(ReportProperty.Properties.REPORT_CONFIG);
    }

    public static ReportProperty find(ReportGroup group, String property) {
        if (group == null) {
            throw new IllegalArgumentException("ReportGroup cannot be null for a report config.");
        }
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("Property cannot be null or empty for a report config.");
        }
        ReportProperty reportProperty = PersistenceManager.getObject(ReportProperty.class, Query.select(ReportProperty.class).equals(ReportProperty.Properties.REPORT_GROUP, (Object)group).equals(ReportProperty.Properties.PROP, property).toString(), null);
        if (reportProperty == null) {
            reportProperty = new ReportProperty(group, property);
            reportProperty.save();
        }
        return reportProperty;
    }

    public static ReportProperty makeConfigReportProperty(String property, ReportConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Cannot make a config report property without a config.");
        }
        ReportProperty newProp = new ReportProperty(ReportGroup.Config, property);
        newProp.setReportConfig(config);
        return newProp;
    }

    private ReportProperty(ReportGroup group, String property) {
        this.reportConfig = this.createReference(ReportProperty.Properties.REPORT_CONFIG);
        this.reportGroup = group;
        this.prop = property;
        this.value = null;
    }

    @Column(name="report_group", nullable=false)
    @Enumerated(value=EnumType.STRING)
    public ReportGroup getReportGroup() {
        return this.reportGroup;
    }

    protected void setReportGroup(ReportGroup group) {
        this.reportGroup = group;
    }

    @Column(name="prop", nullable=false)
    public String getProp() {
        return this.prop;
    }

    protected void setProp(String value) {
        this.prop = value;
    }

    @Column(name="value", nullable=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_report")
    public ReportConfig getReportConfig() {
        return this.reportConfig.get();
    }

    protected void setReportConfig(ReportConfig yourConfig) {
        this.reportConfig.set(yourConfig);
    }

    public String getStringValue(String defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        return this.value;
    }

    @Transient
    public Integer getIntValue(Integer defaultValue) {
        try {
            if (this.value != null) {
                return Integer.valueOf(this.value);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to a number, returning null.");
        }
        return defaultValue;
    }

    @Transient
    public Double getDoubleValue(Double defaultValue) {
        try {
            if (this.value != null) {
                return Double.valueOf(this.value);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to a double, returning null.");
        }
        return defaultValue;
    }

    @Transient
    public Boolean getBooleanValue(Boolean defaultValue) {
        if (this.value != null) {
            return Boolean.valueOf(this.value);
        }
        return defaultValue;
    }

    @Transient
    public Date getDateValue(Date defaultValue) {
        try {
            Long millis;
            if (this.value != null && (millis = Long.valueOf(this.value)) != null) {
                return new Date(millis);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to a number, returning null.");
        }
        return defaultValue;
    }

    public <T extends PersistentObject> T getAsObject(Class<T> clazz, T defaultObject) {
        try {
            Long id;
            if (this.value != null && (id = Long.valueOf(this.value)) != null) {
                return PersistenceManager.getByID(id, clazz);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot convert value " + this.value + " to an object of type " + clazz + ", returning null.");
        }
        return defaultObject;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return !this.isPersistent();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<ReportGroup> REPORT_GROUP;
        public PropertiedObject.Property<String> PROP;
        public PropertiedObject.Property<String> VALUE;
        public PropertiedObject.Property<ReportConfig> REPORT_CONFIG;
    }
}

