/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.webresource;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.database.config.webresource.WebResourceLogConfig;
import ordermate.database.config.webresource.WebResourceProperty;
import ordermate.database.config.webresource.WebResourceType;
import ordermate.database.config.webresource.WebResourceUserLink;
import ordermate.database.dbconstants.SystemState;

public class WebResource
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private SystemState systemState;
    private WebResourceType resourceType;
    private Reference<WebResourceLogConfig> logConfig;
    private String context;
    private boolean secure;
    private boolean ipRestricted;
    private String whiteList;
    private transient List<String> actualWhiteList;
    private PersistentWriteableList<WebResourceProperty> resourceProperties;
    private PersistentList<WebResourceUserLink> userLinks;

    @Deprecated
    public WebResource() {
        this.logConfig = this.createReference(WebResource.Properties.LOG_CONFIG);
        this.resourceProperties = this.createWriteableList(WebResource.Properties.RESOURCE_PROPERTIES);
        this.userLinks = this.createList(WebResource.Properties.USER_LINKS);
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        if (value != null) {
            this.systemState = value;
        }
    }

    public WebResourceType getResourceType() {
        return this.resourceType;
    }

    protected void setResourceType(WebResourceType type) {
        if (this.resourceType == null) {
            this.resourceType = type;
        }
    }

    public String getActualContext() {
        StringBuilder SB = new StringBuilder("/");
        if (this.context != null && !this.context.trim().isEmpty()) {
            SB.append(this.context);
        } else {
            SB.append(this.resourceType.getDefaultContext());
        }
        SB.append("/*");
        return SB.toString();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String value) {
        this.context = value;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean value) {
        this.secure = value;
    }

    public List<WebResourceProperty> getResourceProperties() {
        return this.resourceProperties;
    }

    protected void setResourceProperties(List<WebResourceProperty> newValues) {
        this.resourceProperties.set(newValues);
    }

    public List<WebResourceUserLink> getUserLinks() {
        return this.userLinks;
    }

    protected void setUserLinks(List<WebResourceUserLink> newLinks) {
        this.userLinks.set(newLinks);
    }

    public boolean isIpRestricted() {
        return this.ipRestricted;
    }

    public void setIpRestricted(boolean value) {
        this.ipRestricted = value;
    }

    public String getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(String value) {
        this.whiteList = value;
        this.actualWhiteList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getActualWhiteList() {
        if (this.actualWhiteList == null) {
            WebResource webResource = this;
            synchronized (webResource) {
                this.actualWhiteList = StringUtils.splitToList(this.whiteList, ",");
            }
        }
        return this.actualWhiteList;
    }

    public WebResourceLogConfig getLogConfig() {
        return this.logConfig.get();
    }

    public void setLogConfig(WebResourceLogConfig config) {
        if (config != null) {
            this.logConfig.set(config);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.resourceProperties.saveChild();
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static ObjectQuery getByType(WebResourceType type) {
        return Query.select(WebResource.class).equals(WebResource.Properties.RESOURCE_TYPE, (Object)type);
    }

    public static List<WebResource> getAllResources() {
        return PersistenceManager.getObjectList(WebResource.class, Query.select(WebResource.class).toString());
    }

    public WebResourceProperty getResourceProperty(String key, String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot query for a null key");
        }
        for (WebResourceProperty property : this.resourceProperties) {
            if (!key.equals(property.getKey())) continue;
            return property;
        }
        WebResourceProperty property = new WebResourceProperty(this, key, defaultValue);
        this.resourceProperties.add(property);
        return property;
    }

    public void removeProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot query for a null key");
        }
        WebResourceProperty deleteThis = null;
        for (WebResourceProperty property : this.resourceProperties) {
            if (!key.equals(property.getKey())) continue;
            deleteThis = property;
            break;
        }
        if (deleteThis != null) {
            this.resourceProperties.remove(deleteThis);
        }
    }

    @Override
    public String toString() {
        return this.resourceType != null ? this.resourceType.name() : "No Resource";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<WebResourceType> RESOURCE_TYPE;
        public PropertiedObject.Property<String> CONTEXT;
        public PersistentObject.DerivedProperty<String> ACTUAL_CONTEXT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)WebResource.class), "actualContext");
        public PropertiedObject.Property SECURE;
        public PropertiedObject.Property<WebResourceProperty> RESOURCE_PROPERTIES;
        public PropertiedObject.Property<WebResourceUserLink> USER_LINKS;
        public PropertiedObject.Property IP_RESTRICTED;
        public PropertiedObject.Property<String> WHITE_LIST;
        public PersistentObject.DerivedProperty<String> ACTUAL_WHITE_LIST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)WebResource.class), "actualWhiteList");
        public PropertiedObject.Property<WebResourceLogConfig> LOG_CONFIG;
    }
}

