/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.webresource;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import ordermate.database.config.LoggingStrategy;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_web_resource_log")
@AccessType(value="property")
public class WebResourceLogConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private boolean enabled = false;
    private LoggingLevel logLevel;
    private LoggingStrategy requestLogStrategy;
    private LoggingStrategy responseLogStrategy;

    @Deprecated
    public WebResourceLogConfig() {
    }

    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="log_level")
    public LoggingLevel getLogLevel() {
        return this.logLevel;
    }

    protected void setLogLevel(LoggingLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="request_log_strategy")
    public LoggingStrategy getRequestLogStrategy() {
        return this.requestLogStrategy;
    }

    protected void setRequestLogStrategy(LoggingStrategy strategy) {
        this.requestLogStrategy = strategy;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="response_log_strategy")
    public LoggingStrategy getResponseLogStrategy() {
        return this.responseLogStrategy;
    }

    protected void setResponseLogStrategy(LoggingStrategy strategy) {
        this.responseLogStrategy = strategy;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        if (this.logLevel != null) {
            return this.logLevel.toString();
        }
        return LoggingLevel.NONE.toString();
    }

    public static enum LoggingLevel {
        NONE("No logging"),
        LIGHT("Light Level Logging"),
        MEDIUM("Medium Level Logging"),
        FULL("Full Level Logging");

        public static final Map<String, LoggingLevel> register;
        private String description;

        private LoggingLevel(String desc) {
            this.description = desc;
        }

        public String getDescription() {
            return this.description;
        }

        static {
            register = PersistentEnumeration.buildRegister(LoggingLevel.values());
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<LoggingLevel> LOG_LEVEL;
        public PropertiedObject.Property<Boolean> ENABLED;
        public PropertiedObject.Property<LoggingStrategy> REQUEST_LOG_STRATEGY;
        public PropertiedObject.Property<LoggingStrategy> RESPONSE_LOG_STRATEGY;
    }
}

