/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.config.webresource;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.config.webresource.WebResourceType;
import ordermate.database.config.webresource.WebResourceUserLink;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.misc.SystemCurrentInfo;

public class WebResourceUser
extends PersistentObject
implements Saveable {
    private static final String USER_LABEL = "OPay";
    public static final String EMAIL_POSTFIX = "_oolio@oolio.com";
    public static final int PWD_MAX_LENGTH = 8;
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private String label;
    private String group;
    private String username;
    private String password;
    private Date lastAccessed;
    private PersistentWriteableList<WebResourceUserLink> links;

    @Deprecated
    public WebResourceUser() {
        this.links = this.createWriteableList(WebResourceUser.Properties.LINKS);
    }

    public WebResourceUser(String newLabel) {
        this.links = this.createWriteableList(WebResourceUser.Properties.LINKS);
        this.label = newLabel;
        this.group = "Default";
        this.username = Integer.toString((int)(Math.random() * 1000000.0));
        this.password = Integer.toString((int)(Math.random() * 1000000.0));
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        this.systemState = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (!"OrderMate Online".equals(this.label)) {
            this.label = value;
        } else {
            OrderMate.LOG.warn("Cannot rename the ordermate web user to " + value);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public Date getLastAccessed() {
        return this.lastAccessed;
    }

    protected void setLastAccessed(Date value) {
        this.lastAccessed = value;
    }

    public List<WebResourceUserLink> getLinks() {
        return this.links;
    }

    protected void setLinks(List<WebResourceUserLink> newLinks) {
        this.links.set(newLinks);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.links.saveChild();
    }

    @Override
    public void delete() {
        if (!"OrderMate Online".equals(this.getLabel())) {
            PersistenceManager.delete(this);
        } else {
            OrderMate.LOG.warn("Cannot delete the ordermate user");
        }
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static WebResourceUser createWebResourceUserForOpay(String email, String password, long storeID) {
        WebResourceUser user = new WebResourceUser(USER_LABEL);
        user.setUsername(email);
        user.setPassword(password);
        user.setSystemState(SystemState.ACTIVE_STATE);
        user.setStoreId(storeID);
        WebResource oolioAdyenTxnWebResource = PersistenceManager.getObject(WebResource.class, WebResource.getByType(WebResourceType.oolioAdyenTxn).toString());
        WebResource oolioPayAtTableWebResource = PersistenceManager.getObject(WebResource.class, WebResource.getByType(WebResourceType.oolioPayAtTable).toString());
        WebResourceUserLink oolioAdyenTxnWebResourceUserLink = new WebResourceUserLink(oolioAdyenTxnWebResource, user);
        WebResourceUserLink oolioPayAtTableWebResourceUserLink = new WebResourceUserLink(oolioPayAtTableWebResource, user);
        user.getLinks().add(oolioAdyenTxnWebResourceUserLink);
        user.getLinks().add(oolioPayAtTableWebResourceUserLink);
        user.save();
        return user;
    }

    public static WebResourceUser getExistingDefaultUser() {
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        String email = String.valueOf(redbackId) + EMAIL_POSTFIX;
        WebResourceUser user = PersistenceManager.getObject(WebResourceUser.class, Query.select(WebResourceUser.class).equals(WebResourceUser.Properties.USERNAME, email).toString());
        return user;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> GROUP;
        public PropertiedObject.Property<String> USERNAME;
        public PropertiedObject.Property<String> PASSWORD;
        public PropertiedObject.Property<Date> LAST_ACCESSED;
        public PropertiedObject.Property<WebResourceUserLink> LINKS;
    }
}

