/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.contest;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.contest.ContestEntity;
import ordermate.database.contest.ContestEntityType;
import ordermate.database.contest.ContestHelper;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.combos.InventoryCombo;
import org.hibernate.annotations.Type;

@Entity
@Table(name="contest")
public class Contest
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private String name;
    private String description;
    private boolean showInWaitermate = false;
    private PersistentWriteableList<ContestEntity> entities;

    @Deprecated
    public Contest() {
        this.entities = (PersistentWriteableList)this.createList(Contest.Properties.ENTITIES);
    }

    public Contest(String name) {
        this.entities = (PersistentWriteableList)this.createList(Contest.Properties.ENTITIES);
        this.name = name;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="show_in_waitermate")
    public boolean isShowInWaitermate() {
        return this.showInWaitermate;
    }

    public void setShowInWaitermate(boolean value) {
        this.showInWaitermate = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState state) {
        this.systemState = state;
    }

    @Transient
    public List<ContestEntity> getEntities() {
        return this.entities.getUnmodifiable();
    }

    protected void setEntities(List<ContestEntity> newEntities) {
        this.entities.set(newEntities);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.entities.saveChild();
    }

    @Override
    public void delete() {
        this.entities.deleteChild();
        this.setSystemState(SystemState.DELETED_STATE);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Transient
    public <T> List<T> getBusinessObjects(ContestEntityType entityType) {
        return ContestHelper.INSTANCE.getBusinessObjects(this, entityType);
    }

    @Transient
    public List<ContestEntity> getEntities(ContestEntityType entityType) {
        ArrayList<ContestEntity> sectionEntities = new ArrayList<ContestEntity>();
        for (ContestEntity entity : this.entities) {
            if (!entityType.equals((Object)entity.getEntityType())) continue;
            sectionEntities.add(entity);
        }
        return sectionEntities;
    }

    public <T> void setEntities(ContestEntityType entityType, Collection<T> newBusinessObjects) {
        List<ContestEntity> entitiesToRemove = this.getEntities(entityType);
        for (T newBusinessObj : newBusinessObjects) {
            Long newBusinessObjID = ((PersistentObject)newBusinessObj).getID();
            ContestEntity contestEntity = ContestHelper.INSTANCE.getContestEntity(this, newBusinessObjID, entityType);
            if (contestEntity == null) {
                ContestEntity newEntity = new ContestEntity(this, entityType, newBusinessObjID);
                this.entities.add(newEntity);
                continue;
            }
            entitiesToRemove.remove(contestEntity);
        }
        for (ContestEntity entityToRemove : entitiesToRemove) {
            this.entities.remove(entityToRemove);
        }
    }

    @Transient
    public List<InventoryGroup> getSections() {
        return this.getBusinessObjects(ContestEntityType.Section);
    }

    public void setSections(List<InventoryGroup> sections) {
        this.setEntities(ContestEntityType.Section, sections);
    }

    @Transient
    public List<InventoryCategory> getCategories() {
        return this.getBusinessObjects(ContestEntityType.Category);
    }

    public void setCategories(List<InventoryCategory> categories) {
        this.setEntities(ContestEntityType.Category, categories);
    }

    @Transient
    public List<InventoryItem> getItems() {
        return this.getBusinessObjects(ContestEntityType.Item);
    }

    public void setItems(List<InventoryItem> items) {
        this.setEntities(ContestEntityType.Item, items);
    }

    @Transient
    public List<InventoryItemUnit> getItemUnits() {
        return this.getBusinessObjects(ContestEntityType.ItemUnit);
    }

    public void setItemUnits(List<InventoryItemUnit> itemUnits) {
        this.setEntities(ContestEntityType.ItemUnit, itemUnits);
    }

    @Transient
    public List<InventoryCombo> getCombos() {
        return this.getBusinessObjects(ContestEntityType.Combo);
    }

    public void setCombos(List<InventoryCombo> combos) {
        this.setEntities(ContestEntityType.Combo, combos);
    }

    @Transient
    public List<InventoryAddGroup> getPlusGroups() {
        return this.getBusinessObjects(ContestEntityType.PlusGroup);
    }

    public void setPlusGroups(List<InventoryAddGroup> plusGroups) {
        this.setEntities(ContestEntityType.PlusGroup, plusGroups);
    }

    @Transient
    public List<InventoryAdd> getPluses() {
        return this.getBusinessObjects(ContestEntityType.Plus);
    }

    public void setPluses(List<InventoryAdd> pluses) {
        this.setEntities(ContestEntityType.Plus, pluses);
    }

    @Transient
    public List<InventoryOptionGroup> getOptionGroups() {
        return this.getBusinessObjects(ContestEntityType.OptionGroup);
    }

    public void setOptionGroups(List<InventoryOptionGroup> optionGroups) {
        this.setEntities(ContestEntityType.OptionGroup, optionGroups);
    }

    @Transient
    public List<InventoryOption> getOptions() {
        return this.getBusinessObjects(ContestEntityType.Option);
    }

    public void setOptions(List<InventoryOption> options) {
        this.setEntities(ContestEntityType.Option, options);
    }

    @Override
    public String toString() {
        return this.name != null ? this.name : "";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<Boolean> SHOW_IN_WAITERMATE;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<ContestEntity> ENTITIES;
        public PersistentObject.DerivedProperty<InventoryCategory> CATEGORIES = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "categories");
        public PersistentObject.DerivedProperty<InventoryGroup> SECTIONS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "sections");
        public PersistentObject.DerivedProperty<InventoryItem> ITEMS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "items");
        public PersistentObject.DerivedProperty<InventoryItemUnit> ITEM_UNITS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "itemUnits");
        public PersistentObject.DerivedProperty<InventoryCombo> COMBOS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "combos");
        public PersistentObject.DerivedProperty<InventoryAddGroup> PLUS_GROUPS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "plusGroups");
        public PersistentObject.DerivedProperty<InventoryAdd> PLUSES = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "pluses");
        public PersistentObject.DerivedProperty<InventoryOptionGroup> OPTION_GROUPS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "optionGroups");
        public PersistentObject.DerivedProperty<InventoryOption> OPTIONS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Contest.class), "options");
    }
}

